#include "CmdTxFrequency.h"
#include <climits>

CmdTxFrequency::CmdTxFrequency(mDot* dot, mts::MTSSerial& serial) :
    Command(dot, "Tx Frequency", "AT+TXF", "Set Tx frequency"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    if (_dot->getFrequencyBand() == mDot::FB_868)
        _usage = "(0,863000000-870000000)";
    else
        _usage = "(0,902000000-928000000)";
    _queryable = true;
}

uint32_t CmdTxFrequency::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("Tx Frequency: ");

        _serial.writef("%lu\r\n", _dot->getTxFrequency());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        int frequency = 0;

        sscanf(args[1].c_str(), "%d", &frequency);
        if ((code = _dot->setTxFrequency(frequency)) != mDot::MDOT_OK)
        {
            
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdTxFrequency::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        int frequency = ULONG_MAX;
        if (sscanf(args[1].c_str(), "%d", &frequency) != 1) {
            setErrorMessage("Invalid argument");
            return false;
        }

        if (frequency != 0 && (frequency < int(_dot->getMinFrequency()) || frequency > int(_dot->getMaxFrequency()))) {
            if (_dot->getFrequencyBand() == mDot::FB_868)
                setErrorMessage("Invalid frequency, expects (0,863000000-870000000)"); 
            else
                setErrorMessage("Invalid frequency, expects (0,902000000-928000000)");

            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}

