#include "CmdReceiveOnce.h"
#include "CommandTerminal.h"

CmdReceiveOnce::CmdReceiveOnce(mDot* dot, mts::MTSSerial& serial) : Command(dot, "Receive Once", "AT+RECV", "Receive and display one packet."),
    _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(string:242) or (hex:242)";
}

uint32_t CmdReceiveOnce::action(std::vector<std::string> args)
{
    std::vector<uint8_t> data;

    if (_dot->recv(data) == mDot::MDOT_OK) {
        if (_dot->getVerbose())
            _serial.writef("Packet data:\r\n");

        if (!data.empty())
            _serial.writef("%s\r\n", CommandTerminal::formatPacketData(data, _dot->getRxOutput()).c_str());
    }

    return 0;
}

bool CmdReceiveOnce::verify(std::vector<std::string> args)
{
	if (args.size() == 1)
		return true;

    setErrorMessage("Invalid arguments");
    return false;
}
