/*
 * CmdJoinDelay.cpp
 *
 *  Created on: Nov 4, 2015
 *      Author: jreiss
 */

#include "CmdJoinDelay.h"

CmdJoinDelay::CmdJoinDelay(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Join Delay", "AT+JD", "Number of seconds before receive windows are opened for join (1 - 15)"),
  _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(1-15)";
    _queryable = true;
}

CmdJoinDelay::~CmdJoinDelay()
{
    // TODO Auto-generated destructor stub
}

uint32_t CmdJoinDelay::action(std::vector<std::string> args) {
    if (args.size() == 1) {
        if (_dot->getVerbose())
            _serial.writef("Join Delay: ");

        _serial.writef("%u\r\n", _dot->getJoinDelay());
    } else if (args.size() == 2) {
        int32_t code;
        uint32_t joinDelay;
        sscanf(args[1].c_str(), "%lu", &joinDelay);

        if ((code = _dot->setJoinDelay(joinDelay)) != mDot::MDOT_OK) {
            
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }
    return 0;
}

bool CmdJoinDelay::verify(std::vector<std::string> args) {
    if (args.size() == 1)
        return true;

    if (args.size() == 2) {

        int joinDelay;
        if (sscanf(args[1].c_str(), "%d", &joinDelay) == 1) {
            if (joinDelay > 15 || joinDelay < 1) {
                setErrorMessage("Invalid join delay, expects (1-15)");
                return false;
            }
            return true;
        }
    }

    setErrorMessage("Invalid arguments");
    return false;
}
