#include "CmdAntennaGain.h"

CmdAntennaGain::CmdAntennaGain(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Antenna Gain", "AT+ANT", "Gain in dBi of installed antenna (-128-127)"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(-128-127)";
    _queryable = true;
}

uint32_t CmdAntennaGain::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("Antenna Gain: ");

        _serial.writef("%d\r\n", _dot->getAntennaGain());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        int gain;
        sscanf(args[1].c_str(), "%d", &gain);

        if ((code = _dot->setAntennaGain(gain)) != mDot::MDOT_OK)
        {
            setErrorMessage(_dot->getLastError());
            return 1;
        }
    }

    return 0;
}

bool CmdAntennaGain::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        int gain;
        if (sscanf(args[1].c_str(), "%d", &gain) != 1) {
            setErrorMessage("Invalid argument");
            return false;
        }

        if (gain < -128 || gain > 127) {
            setErrorMessage("Invalid gain, expects (-127-128)");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
