#include "CmdSnr.h"

CmdSnr::CmdSnr(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Signal To Noise Ratio", "AT+SNR", "Display signal to noise ratio of received packets: last, min, max, avg in dB"),
        _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(-20.0-20.0),(-20.0-20.0),(-20.0-20.0),(-20.0-20.0)";
    _queryable = true;
}

uint32_t CmdSnr::action(std::vector<std::string> args)
{
    mDot::snr_stats stats = _dot->getSnrStats();

    if (_dot->getVerbose())
        _serial.writef("SNR stats: ");

    _serial.writef("%d.%d, %d.%d, %d.%d, %d.%d\r\n", stats.last / 10, abs(stats.last % 10), stats.min / 10, abs(stats.min % 10), stats.max / 10, abs(stats.max % 10), stats.avg / 10, abs(stats.avg % 10));

    return 0;
}
