#include "CmdSendBinary.h"
#include "CommandTerminal.h"

CmdSendBinary::CmdSendBinary(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Send Binary", "AT+SENDB", "Sends supplied binary (hex) packet data one time and return response"),
  _serial(serial) {
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(hex:242)";
}

uint32_t CmdSendBinary::action(std::vector<std::string> args) {
    std::vector<uint8_t> data;
    int32_t code;
    int temp;
    uint32_t length = args[1].size();

    // Convert the ASCII hex data to binary...
    for (uint32_t i = 0; i < length; i += 2) {
        sscanf(&args[1][i], "%2x", &temp);
        data.push_back(temp);
    }

    if ((code = _dot->send(data, _dot->getTxWait())) != mDot::MDOT_OK) {
        std::string error = mDot::getReturnCodeString(code);

        if (code != mDot::MDOT_NOT_JOINED)
            error +=  + " - " + _dot->getLastError();

        setErrorMessage(_dot->getLastError());;
        return 1;
    }

    data.clear();

    if (_dot->getTxWait() && _dot->recv(data) == mDot::MDOT_OK) {
        if (!data.empty()) {
            if (_dot->getVerbose())
                _serial.writef("Packet data:\r\n");
            _serial.writef("%s\r\n", CommandTerminal::formatPacketData(data, _dot->getRxOutput()).c_str());
        }
    }

    return 0;
}

bool CmdSendBinary::verify(std::vector<std::string> args) {
    if (args.size() == 2) {
        if (args[1].size() > 484 || !isHexString(args[1], args[1].size() / 2)) {
            setErrorMessage("Invalid hex string, (hex:242)");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}

