#include "CmdRxInverted.h"

CmdRxInverted::CmdRxInverted(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Set Rx inverted", "AT+RXI", "Set Rx signal inverted, (default:on)"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0,1)";
    _queryable = true;
}

uint32_t CmdRxInverted::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("Rx Inverted: ");

        _serial.writef("%d\r\n", _dot->getRxInverted());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        bool invert = args[1] == "1";
        if ((code = _dot->setRxInverted(invert)) != mDot::MDOT_OK)
        {
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdRxInverted::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        if (!(args[1] == "0" || args[1] == "1")) {
            setErrorMessage("Invalid parameter, expects (0: off, 1: on)");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
