#include "CmdNetworkLinkCheck.h"
#include "CommandTerminal.h"

CmdNetworkLinkCheck::CmdNetworkLinkCheck(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Network Link Check", "AT+NLC", "Perform network link check, displays dBm above floor, number of gateways in range and optional packet payload if received"),
  _serial(serial) {
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(-20.0-20.0),(1-)";
}

uint32_t CmdNetworkLinkCheck::action(std::vector<std::string> args) {
    mDot::link_check lc;

    lc = _dot->networkLinkCheck();
    if (lc.status) {
        if (_dot->getVerbose())
            _serial.writef("%s:", name());

        _serial.writef("%d,%lu\r\n", lc.dBm, lc.gateways);

        if (!lc.payload.empty())
            _serial.writef("%s\r\n", CommandTerminal::formatPacketData(lc.payload, _dot->getRxOutput()).c_str());

    } else {
        setErrorMessage(_dot->getLastError());
        return 1;
    }

    return 0;
}

