#include "CmdErrorCorrection.h"

CmdErrorCorrection::CmdErrorCorrection(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Error Correction", "AT+FEC", "Configure Forward Error Correction bytes (1 to 4)"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(1-4)";
    _queryable = true;
}

uint32_t CmdErrorCorrection::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("Error Correction Bytes: ");

        _serial.writef("%u\r\n", _dot->getFec());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        uint32_t bytes;
        sscanf(args[1].c_str(), "%lu", &bytes);

        if ((code = _dot->setFec(bytes)) != mDot::MDOT_OK)
        {
            
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdErrorCorrection::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        int retries;
        if (sscanf(args[1].c_str(), "%d", &retries) != 1) {
            setErrorMessage("Invalid argument");
            return false;
        }

        if (retries < 1 || retries > 4)
        {
            setErrorMessage("Invalid bytes, expects (1-4)");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
