#include "CmdDataPending.h"

CmdDataPending::CmdDataPending(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Data Pending", "AT+DP", "Indicator of data in queue on server"),
        _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0,1)";
    _queryable = true;
}

uint32_t CmdDataPending::action(std::vector<std::string> args)
{
    if (_dot->getVerbose())
        _serial.writef("Data Pending: ");

    _serial.writef("%d\r\n", _dot->getDataPending());

    return 0;
}

