#include "CmdLinkCheckThreshold.h"

CmdLinkCheckThreshold::CmdLinkCheckThreshold(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Link Check Threshold", "AT+LCT", "Set threshold for number of link check or ACK failures to tolerate, (0: off, N: number of failures)"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0-255)";
    _queryable = true;
}

uint32_t CmdLinkCheckThreshold::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("Link Check Threshold: ");

        _serial.writef("%u\r\n", _dot->getLinkCheckThreshold());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        int count;
        sscanf(args[1].c_str(), "%d", &count);

        if ((code = _dot->setLinkCheckThreshold(count)) != mDot::MDOT_OK)
        {
            
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdLinkCheckThreshold::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        int count;
        sscanf(args[1].c_str(), "%d", &count);

        if (count < 0 || count > 255) {
            setErrorMessage("Invalid count, expects (0-255))");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
