#include "CmdLinkCheckCount.h"

CmdLinkCheckCount::CmdLinkCheckCount(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Link Check Count", "AT+LCC", "Set number of packets between each link check if ACK's are disabled"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0:off,N:Packets (max 255))";
    _queryable = true;
}

uint32_t CmdLinkCheckCount::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("Link Check Count: ");

        _serial.writef("%u\r\n", _dot->getLinkCheckCount());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        int count;
        sscanf(args[1].c_str(), "%d", &count);

        if ((code = _dot->setLinkCheckCount(count)) != mDot::MDOT_OK)
        {
            
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdLinkCheckCount::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        int count;
        if (sscanf(args[1].c_str(), "%d", &count) != 1) {
            setErrorMessage("Invalid argument");
            return false;
        }

        if (count < 0 || count > 255) {
            setErrorMessage("Invalid count, expects (0:off,N:Packets (max 255))");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
