#include "CmdDisplayStats.h"

CmdDisplayStats::CmdDisplayStats(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Display Stats", "AT&S", "Display statistics"),
  _serial(serial), _dot(dot) {
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "TABLE";
}

uint32_t CmdDisplayStats::action(std::vector<std::string> args) {

    mDot::mdot_stats stats = _dot->getStats();

    _serial.writef("Join Attempts:  %5lu\r\n", stats.Joins);
    _serial.writef("Join Fails:     %5lu\r\n", stats.JoinFails);
    _serial.writef("Up Packets:     %5lu\r\n", stats.Up);
    _serial.writef("Down Packets:   %5lu\r\n", stats.Down);
    _serial.writef("Missed Acks:    %5lu\r\n", stats.MissedAcks);

    return 0;
}

