#include "CmdDeviceClass.h"
#include "CommandTerminal.h"

CmdDeviceClass::CmdDeviceClass(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Device Class", "AT+DC", "Device class (A,B,C)"),
  _serial(serial) {
    _help = std::string(text()) + ": " + std::string(desc());
    _queryable = true;
    _usage = "(A,B,C)";
}

CmdDeviceClass::~CmdDeviceClass() {

}

uint32_t CmdDeviceClass::action(std::vector<std::string> args) {

    if (args.size() == 1) {
        if (_dot->getVerbose())
            _serial.writef("Device Class:\r\n");
        _serial.writef("%s\r\n", _dot->getClass().c_str());
    } else {
        int32_t code;
        if ((code = _dot->setClass(args[1])) != mDot::MDOT_OK) {
            
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdDeviceClass::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2) {
        args[1] = mts::Text::toUpper(args[1]);
        if (args[1] == "A" || args[1] == "B" || args[1] == "C") {
            return true;
        }
    }

    setErrorMessage("Invalid arguments");
    return false;
}
