//      *******************************************
//      *** phase ramps & steps without the RAM ***
//      *******************************************

#include "mbed.h"
#include "AD9954.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);
DigitalOut cs2(p11);
DigitalOut cs1(p8);
DigitalOut rst(p9);
DigitalOut update(p10);
DigitalOut trigger(p13);
AD9954 myDevice(p5, p6, p7, p8, p9, p10);
        
    int reset() 
    {    
        rst = 1;
        wait(0.1);
        rst = 0 ;
        return 0;
        }
        
    int ch_1() { cs1 = 0; cs2 = 1; return 0; }
    int ch_2() { cs1 = 1; cs2 = 0; return 0; }
    
int main() {
        
        pc.printf("*************************************************** \n \r"); 
        pc.printf("*** Phase steps and slow phase ramp without RAM *** \n \r"); 
        pc.printf("*************************************************** \n \r"); 
        pc.printf("Enter: \n \r");
        pc.printf("'1' or '2' --> which output channel should be ramped. \n \r"); 
        pc.printf("'p' --> enter the final phase value in degree. The DDS will start to make phase steps 0-->final value with a 5 kHz frequency. The signal can be observed with the mbed trigger on pin 13 \n \r"); 
        pc.printf("'r' --> A phase ramp from 0-->359 degree in 700 steps is started. The ramp takes approximately a millisecond. It is repeated until another key is pressed.\n \r");
        
        double freq0;
        freq0 = 80.0e6;         // Output frequency of both output channels
        double clock = 400.0e6; // Frequency of external clock signal
        trigger = 0;
        reset(); 

// Set output channel 1 and 2 to the frequency "freq0":        
ch_1();             

        myDevice.CFR1_write(0x00000200);
        uint32_t FTWO = 0xFFFFFFFF & (int)(freq0/clock*pow(2.0,32.0));
        myDevice.FTW0_write(FTWO);
        pc.printf("channel 1 frequency %f \n \r", freq0); 

        
ch_2();
        
        myDevice.CFR1_write(0x00000200);
        myDevice.FTW0_write(FTWO);
   
        double phase = 0.0; // in degree 
        uint32_t PHWO = int(phase/360.0*pow(2.0,14.0));
        myDevice.PHWO_write(PHWO);


// This sequency watches the TeraTerm-Terminal and triggers actions,
// when a certain key is pressed:
        
        char std;
        while(1) {
        pc.scanf("%c",&std);
        // Ramp channel 1 or channel 2 by pressing entering "1" or "2" in TeraTerm
        if (std == '1') { ch_1(); pc.printf("ch1 selected \r\n"); };
        if (std == '2') { ch_2(); pc.printf("ch2 selected \r\n"); };
        // Enter "p" --> enter the final phase value in degree. The DDS will start to make phase steps 0-->final value with
        // a 5 kHz frequency. The signal can be observed with the mbed trigger on pin 13
        if (std == 'p') { 
            trigger = 0;
            pc.printf("enter final phase: \r \n");
            pc.scanf("%lf", &phase);
            pc.printf("entered: %lf \r \n", phase);
            uint32_t PHWO = rint(phase/360.0*pow(2.0,14.0));
            while(1) {
                myDevice.PHWO_write(0);
                wait_us(200);       
                trigger = 1;
                myDevice.PHWO_write(PHWO);     
                trigger = 0;   
                if (pc.readable()) break;
            }};
        // Enter "r" --> A phase ramp from 0-->359 degree in 700 steps is started. The ramp takes approximately
        // a millisecond. It is repeated until another key is pressed.
        if (std == 'r') {
            pc.printf("entered r -> starting phase ramp\r \n");
            int i;
            int steps = 700;
            double phase0 = 0;
            double phase1 = 359;
            double phase_array[steps+1];
            uint32_t PHWO [steps+1];
            i = 0;
            while(i<=steps) {
                phase_array[i] = phase0 + (phase1-phase0)/steps*i;
                PHWO[i]=rint(phase_array[i]/360.0*pow(2.0,14.0));
                i += 1;
            }
            while(1) {
            myDevice.PHWO_write(PHWO[0]); 
            trigger = 0;
            wait(1e-3);
            i = 0;
            trigger = 1;
            while(i<=steps) {
                myDevice.PHWO_write(PHWO[i]);
                i+=1;
            }  
            trigger = 0;       
            wait(10e-3);
            myDevice.PHWO_write(PHWO[0]); 
            if (pc.readable()) break;
            }};
        };
      
   return 0;
}