#ifndef AD9954_H
#define AD9954_H

#include "mbed.h"

double sysclk = 1.0/(200.0e6);

class AD9954 {

protected:
    SPI         _spi;
    DigitalOut  _cs;
    DigitalOut  _rst;
    DigitalOut  update;
    
public:

    AD9954(PinName mosi, PinName miso, PinName sclk, PinName cs, PinName rst, PinName update) :
        _spi(mosi, miso, sclk), _cs(cs), _rst(rst), update(update)
    { 
        // see http://mbed.org/handbook/SPI and page 23 why format 0
        _spi.format(8, 0);
        _spi.frequency(1000000);
        // master reset the device:
        //_rst = 1;
         //wait(0.1);
        //_rst = 0 ;
    };
    
        
    // Write a 32bit register at the specified address.
    void write_reg_4byte(uint32_t address, uint32_t value) {
        update = 0;
      // Instruction byte: page 25, we want to write (0), so 0100 + internal adress of the register to be written in
        _spi.write(0x00 | (address & 0x1F));
        
        _spi.write((value >> 24) & 0xFF);
        _spi.write((value >> 16) & 0xFF);
        _spi.write((value >> 8) & 0xFF);
        _spi.write((value >> 0) & 0xFF);
        update = 1;
        wait(4*sysclk);
        update =0;
    }
    
    // Write a 24bit register at the specified address.
    void write_reg_3byte(uint32_t address, uint32_t value) {
        update = 0;
      // Instruction byte: page 25, we want to write (0), so 0100 + internal adress of the register to be written in
        _spi.write(0x00 | (address & 0x1F));
        _spi.write((value >> 16) & 0xFF);
        _spi.write((value >> 8) & 0xFF);
        _spi.write((value >> 0) & 0xFF);
        update = 1;
        wait(4*sysclk);
        update =0;
    }
  
      // Write a 2 byte register at the specified address.
    void write_reg_2byte(uint32_t address, uint32_t value) {
        update = 0;
        _spi.write(0x00 | (address & 0x1F));
        _spi.write((value >> 8) & 0xFF);
        _spi.write((value >> 0) & 0xFF);
        update = 1;
        wait(4*sysclk);
        update =0;
    }  
    
    
        // Write a 1byte register at the specified address.
    void write_reg_1byte(uint32_t address, uint32_t value) {
        update = 0;
      // Instruction byte: page 25, we want to write (0), so 0100 + internal adress of the register to be written in
        _spi.write(0x00 | (address & 0x1F));
        _spi.write((value >> 0) & 0xFF);
        update = 1;
        wait(4*sysclk);
        update =0;
    }
     
     
     
// Read a 4 byte register at the specified address.
    uint32_t read_reg_4byte(uint32_t address) {
        uint32_t value = 0;
        _spi.write(0x80 | (address & 0x0F)); // Instruction byte
        value |= _spi.write(0x00);
        value = value << 8;
        value |= _spi.write(0x00);
        value = value << 8;
        value |= _spi.write(0x00);
        value = value << 8;
        value |= _spi.write(0x00);
        return value;
    }  
    
// Read 3 byte register   
    uint32_t read_reg_3byte(uint32_t address) {
        uint32_t value = 0x000000;
        _spi.write(0x80 | (address & 0x0F)); // Instruction byte
        value |= _spi.write(0x00);
        value = value << 8;
        value |= _spi.write(0x00);
        value = value << 8;
        value |= _spi.write(0x00);
        return value;
    }   

// Read 2 byte register    
    uint32_t read_reg_2byte(uint32_t address) {
        uint32_t value = 0x000000;
        _spi.write(0x80 | (address & 0x0F)); // Instruction byte
        value |= _spi.write(0x00);
        value = value << 8;
        value |= _spi.write(0x00);
        return value;
    } 
    
// Read 1 byte register   
    uint32_t read_reg_1byte(uint32_t address) {
        uint32_t value = 0x00;
        _spi.write(0x80 | (address & 0x0F)); // Instruction byte
        value |= _spi.write(0x00);
        return value;
    }   

       
// Write 
    void CFR1_write(uint32_t reg) { write_reg_4byte(0x00, reg); }
    void CFR2_write(uint32_t reg) { write_reg_3byte(0x01, reg); }
    void FTW0_write(uint32_t reg) { write_reg_4byte(0x04, reg); }
    void PHWO_write(uint32_t reg) { write_reg_2byte(0x05, reg); }
    
// Read 
    uint32_t CFR1_read(void) { return read_reg_4byte(0x00); }
    uint32_t CFR2_read(void) { return read_reg_3byte(0x01); }
    uint32_t FTWO_read(void) { return read_reg_4byte(0x04); }  
    uint32_t PHWO_read(void) { return read_reg_2byte(0x05); } 
};

#endif