#include "Touch.h"
#include "main.h"
#include "Screens.h"

// in Bigbutton position same as draw big button position 
// out 1 touch detected 0 no touch detected

uint16_t x, y = 0;
uint16_t touch_x, touch_y = 0;
bool press_detected = false;

TS_StateTypeDef TS_State;
TS_StateTypeDef Old_TS_State;

void CheckTs()
{
    ts.GetState(&TS_State);      
    if (TS_State.TouchDetected)
    {
        x = TS_State.X;
        y = TS_State.Y;
    } 
    if ((Old_TS_State.TouchDetected) && (!TS_State.TouchDetected))
    {
     touch_x = x;
     touch_y = y;
     press_detected = true;   
    }   
    Old_TS_State = TS_State;
}


bool CheckBigButtonTouch (uint8_t position)
{
    bool result = false;
    if((touch_x >= BigButtonX) && (touch_x<=(BigButtonX + BigButtonWidth)))
    {
        switch(position)
        {
            case 1: 
                if((touch_y >= BigButton1Y)&&(touch_y <= (BigButton1Y+BigButtonHeight)))
                {
                    result = true;
                    press_detected = false;  
                } 
            break;
            case 2:
                if((touch_y >= BigButton1Y)&&(touch_y <= (BigButton2Y+BigButtonHeight)))
                { 
                    result = true; 
                    press_detected = false; 
                } 
            break;
            case 3:
                if((touch_y >= BigButton3Y)&&(touch_y <= (BigButton3Y+BigButtonHeight)))
                { 
                    result = true;
                    press_detected = false;  
                }
            break; 
            case 4:
                if((touch_y >= BigButton4Y)&&(touch_y <= (BigButton4Y+BigButtonHeight)))
                { 
                    result = true;
                    press_detected = false;  
                }
            break; 
                 
        }       
    }

    return result; 
}

void CheckPress(ScreenState screen)
{
    if(press_detected)
    {
        switch(screen)
        {
            case StartUp:
                //Mode Cpap
                if(CheckBigButtonTouch(1))
                {
                    display_screen = CPAPMain;
                    refreshScreen = true;
                    break; 
                }
                // Mode niv 
                if(CheckBigButtonTouch (2))
                {
                    display_screen = NIVMain;
                    refreshScreen = true;
                    break; 
                }               
            break;
            case  CPAPMain :
                            //Mode Cpap
                if(CheckBigButtonTouch(1))
                {
                    display_screen = CPAPRunning; // Start CPAP
                    refreshScreen = true;
                    break; 
                }
                // Mode niv 
                if(CheckBigButtonTouch (2)) // Settings CPAP
                {
                    display_screen = CPAPSettingsMain;
                    refreshScreen = true;
                    break; 
                }
                if(CheckBigButtonTouch (3)) 
                {
                    display_screen = StartUp;     // Back to main screen 
                    refreshScreen = true;
                    break; 
                }                                  
            break;
            case NIVMain :
                if(CheckBigButtonTouch(1))
                {
                    display_screen = NIVRunning; // Start NIV
                    refreshScreen = true;
                    break; 
                }
                // Mode niv 
                if(CheckBigButtonTouch (2)) // Settings NIV
                {
                    display_screen =  NIVSettingsMain;
                    refreshScreen = true;
                    break; 
                }
                if(CheckBigButtonTouch (3)) // Back
                {
                    display_screen = StartUp;     // Back to main screen 
                    refreshScreen = true;
                    break; 
                } 
            break;
            case CPAPRunning:
            break;
            case  CPAPSettingsMain:
                if(CheckBigButtonTouch(1))
                {
                    //display_screen = NIVRunning; // Start NIV
                    refreshScreen = true;
                    break; 
                }
                // Mode niv 
                if(CheckBigButtonTouch (2)) // Settings NIV
                {
                    //display_screen =  NIVSettingsMain;
                    refreshScreen = true;
                    break; 
                }
                if(CheckBigButtonTouch (4)) // Back
                {
                    display_screen = CPAPMain;     // Back to main screen 
                    refreshScreen = true;
                    break; 
                } 
            break;       
            case   CPAPSettingsDetailView:
            break;
            case NIVRunning:
            break;
            case  NIVSettingsMain:
            break;
            case NIVSettingsDetailView:
            break;
            default:
            break;
        }       
    }
    
}
