#include "TS_DISCO_F429ZI.h"
#include "LCD_DISCO_F429ZI.h" 
#include "Screens.h"
#include "main.h"

bool refreshScreen = true;
// Pos 1 2 (row of button )
void DrawBigButton(LCD_DISCO_F429ZI lcd, uint8_t position, char* array)
{
   BSP_LCD_SetFont(&Font20);  
   uint8_t text_array[30];
   sprintf((char*)text_array, array);  
   switch (position)
   {
       case 1:
       lcd.DrawRect(BigButtonX, BigButton1Y, BigButtonWidth , BigButtonHeight );
       lcd.DisplayStringAt(0, LINE(4), (uint8_t *)&text_array, CENTER_MODE);
       break;
       case 2:
       lcd.DrawRect(BigButtonX, BigButton2Y, BigButtonWidth , BigButtonHeight );
       lcd.DisplayStringAt(0, LINE(7), (uint8_t *)&text_array, CENTER_MODE);
       break;
       case 3:
       lcd.DrawRect(BigButtonX,BigButton3Y,BigButtonWidth ,BigButtonHeight );
       lcd.DisplayStringAt(0, LINE(10), (uint8_t *)&text_array, CENTER_MODE);
       break;
       case 4:
       lcd.DrawRect(BigButtonX,BigButton4Y,BigButtonWidth ,BigButtonHeight );
       lcd.DisplayStringAt(0, LINE(13), (uint8_t *)&text_array, CENTER_MODE);
       default:
       break;
   }
}

void CreatStartupScreen(LCD_DISCO_F429ZI lcd)
{
    lcd.Clear(LCD_COLOR_DARKGRAY);
    uint8_t text_array[30];
    // Show Title Line - Select Mode 
     BSP_LCD_SetFont(&Font20);          
     sprintf((char*)text_array, "Select Mode");
     lcd.ClearStringLine(1);   
     lcd.DisplayStringAt(0, LINE(1), (uint8_t *)&text_array, CENTER_MODE);
    // Show Two Buttons 
    // first CPAP Mode 
    DrawBigButton(lcd, 1, "CPAP");
        // On Press SHOW CPAP Screen 
    // second NIV 
    DrawBigButton(lcd, 2, "NIV");
        // On Press show NIV Screen    
}
void CreateCPAPMainScreen(LCD_DISCO_F429ZI lcd)
{
    lcd.Clear(LCD_COLOR_DARKGRAY);
    uint8_t text_array[30];
    // Show Title Line - Select Mode 
     BSP_LCD_SetFont(&Font20);          
     sprintf((char*)text_array, "CPAP");   
     lcd.ClearStringLine(1);
     lcd.DisplayStringAt(0, LINE(1), (uint8_t *)&text_array, CENTER_MODE);
    // Show Two Buttons 
    // first CPAP Mode 
    DrawBigButton(lcd, 1, "START");
        // On Press SHOW CPAP Screen 
    // second NIV 
    DrawBigButton(lcd, 2, "SETTINGS");
        // On Press show NIV Screen   
    DrawBigButton(lcd, 3, "BACK"); 
}
void CreateCPAPMainSettingsScreen(LCD_DISCO_F429ZI lcd)
{
   lcd.Clear(LCD_COLOR_DARKGRAY); 
    uint8_t text_array[30];
    // Show Title Line - Select Mode 
     BSP_LCD_SetFont(&Font20);          
     sprintf((char*)text_array, "CPAP Settings");   
     lcd.ClearStringLine(1);
     lcd.DisplayStringAt(0, LINE(1), (uint8_t *)&text_array, CENTER_MODE);
    // Show Two Buttons 
    // first CPAP Mode 
    DrawBigButton(lcd, 1, "PEEP"); 
    DrawBigButton(lcd, 2, "TI"); 
    DrawBigButton(lcd, 3, "OTHER ->"); 
    DrawBigButton(lcd, 4, "BACK"); 
}


void CreateNIVMainScreen(LCD_DISCO_F429ZI lcd)
{
    lcd.Clear(LCD_COLOR_DARKGRAY);
    uint8_t text_array[30];
    // Show Title Line - Select Mode 
     BSP_LCD_SetFont(&Font20);          
     sprintf((char*)text_array, "NIV");   
     lcd.ClearStringLine(1);
     lcd.DisplayStringAt(0, LINE(1), (uint8_t *)&text_array, CENTER_MODE);
    // Show Two Buttons 
    // first CPAP Mode 
    DrawBigButton(lcd, 1, "START");
        // On Press SHOW CPAP Screen 
    // second NIV 
    DrawBigButton(lcd, 2, "SETTINGS");
        // On Press show NIV Screen  
    DrawBigButton(lcd, 3, "BACK");  
}
void showScreen(ScreenState screen,LCD_DISCO_F429ZI lcd)
{ 
    if ( refreshScreen == false )
        return;
    switch(screen) 
    {
        case StartUp :
                CreatStartupScreen(lcd); 
                refreshScreen = false;               
        break;
        case  CPAPMain :
                CreateCPAPMainScreen(lcd);
                refreshScreen = false;
        break;
        case  NIVMain :
                CreateNIVMainScreen(lcd);
                refreshScreen = false;
        break;
        case  CPAPRunning:
        break;
        case   CPAPSettingsMain:
            CreateCPAPMainSettingsScreen(lcd);
            refreshScreen = false;
        break;
        case  CPAPSettingsDetailView:
        break;
        case NIVRunning:
        break;
        case  NIVSettingsMain:
        break;
        case  NIVSettingsDetailView:
        break;



    }
}

