#ifndef __SCREENS_H
#define __SCREENS_H
#ifdef TARGET_DISCO_F429ZI
#include "TS_DISCO_F429ZI.h"
#include "LCD_DISCO_F429ZI.h"

#define BigButtonX          40
#define BigButtonWidth      160
#define BigButtonHeight     35

#define BigButton1Y        70
#define BigButton2Y        130
#define BigButton3Y        190
#define BigButton4Y        250

typedef enum 
{
 StartUp = 0,
 CPAPMain = 1,
 NIVMain = 2,
 CPAPRunning = 3,
 CPAPSettingsMain = 4,
 CPAPSettingsDetailView = 5,
 NIVRunning = 6,
 NIVSettingsMain = 7,
 NIVSettingsDetailView = 8   
} ScreenState;

extern bool refreshScreen;

void CreatStartupScreen(LCD_DISCO_F429ZI lcd);
void DrawBigButton(LCD_DISCO_F429ZI lcd, uint8_t position, char* array);
void showScreen(ScreenState screen,LCD_DISCO_F429ZI lcd);

#else
#error "This class must be used with DISCO_F429ZI board only."
#endif // TARGET_DISCO_F429ZI

#endif   
