#include "mbed.h"
#include "LightSensor.h"
#include "Decagon10HS.h"
#include "DecagonEC-5.h"
#include "DHT.h"
#include "FastIO.h"
#include "DS18B20.h"
#include "WaterMark200ss.h"
#include "WeatherMeters.h"
#include "Anemometer.h"
#include "floathex.h"


//Declaración de Puertos para cada sensor
AnalogIn moisture10HS(A0);  //Decagon 10HS en el A0
AnalogIn light(A1);         //ALS-PT19LIGHT en el A1
AnalogIn moistureEC5(A2);   //Decagon EC-5 en el A2
AnalogIn lightref(A3);      //Referencia 3.3V en el A3
AnalogIn moisture200ss(A4); //WaterMark200ss en el A4

/*El sensor DS18B20 se
define el pin en la
librería DHT*/              //Ds18B20 en el D2
DHT dht22(PB_3,DHT22);      //DHT22 en el D3
CWeatherMeters WeatherMeters(D4, D5, A5); //Weather Station Anemómetro D4, Veleta D5, Pluviómetro A5

//Declaración variables para sensores:
float lightLvl      = 0;    // Sensor LUZ               //Rango: 0.0 a 3.3 //3
float VWC10HS       = 0;    // Sensor 10HS              //Rango: 0.0 a 3.4  //3
float VWCEC5        = 0;    // Sensor EC-5              //Rango: 0.0 a 4 //3
float tempdht22     = 0;    // Sensor DHT22             //Rango: -40.0 a 80 //4
float humdht22      = 0;    // Sensor DHT22             //Rango: 0 a 100% //2
float tempDS18B20   = 0;    // Sensor DS18B20           //Rango: -55.0 a 125.0 //4
float centibar      = 0;    // Sensor WaterMark 200ss   //Rango: 0.0 a 240.0 //2
float rainfall      = 0;    // Weather Station          //Rango: 0 a 100  //3
float windSpeed     = 0;    // Weather Station          //Rango: 0 a 2000 //3
float maxWindSpeed  = 0;    // Weather Station          //Rango: 0 a 2000 //3
float windDir  = 0;         // Weather Station          //Rango: 0 a 337.5 //3
float value;
string lightLvlh;
string VWC10HSh;
string VWCEC5h;
string tempdht22h;
string humdht22h;
string tempDS18B20h;
string centibarh;
string rainfallh;
string windSpeedh;
string maxWindSpeedh;
string windDirh;
char buffer1[11]= " ";
char buffer2[11]= " ";
char buffer3[11]= " ";

void ReadSensors();

int main()
{
    pc.baud(115200);
    DQ.output();
    DQ = 0;
    DQ.input();
    pc.printf("All Sensors Test \r\n");
    pc.printf("Memory allocated for %d DS18B20.\r\n",MaxROMs);
    pc.printf("Scanning for devices...\r\n");
    ow_reset();
    FindDevices();
    pc.printf("Scanning completed.\r\n");


    while(1) {
        //Leer Sensores
        wait(1);
        ReadSensors(); //No hace lectura de la Temperatura con la ds18b20??
        pc.printf("Direction: %s\n",windDir);
        pc.printf("Depth: %f\n",rainfall);
        pc.printf("Current speed: %f\n", windSpeed);
        pc.printf("Maximum speed: %f\n", maxWindSpeed);
        pc.printf("200ss Centibar: %2.2f\n", centibar);
        pc.printf("DHT22 Humidity: %.1f \n\r",humdht22);
        pc.printf("DHT22 Temp: %.1f C",tempdht22);
        pc.printf("EC-5 VWC: %2.2f VMC\r\n", VWCEC5);
        pc.printf("10HS VWC: %2.2f\r\n", VWC10HS);
        pc.printf("Light: %3.2f \r\n", lightLvl);
       
        //Convierto a Hex
        lightLvlh = float2dHex(lightLvl);           // 2 - 1 int 1 dec
        VWC10HSh = float2dHex(VWC10HS);             // 2 - 1 int 1 dec
        VWCEC5h = float2dHex(VWCEC5);               // 2 - 1 int 1 dec
        tempdht22h = float4Hex(tempdht22);          // 4 - 1 signo (1 negativo, 0 positivo) 2 enteros 1 dec
        tempDS18B20h = float4Hex(tempDS18B20);      // 4 - 1 signo (1 negativo, 0 positivo) 2 enteros 1 dec
        humdht22h = float2Hex(humdht22);           // 2 - 2 enteros
        rainfallh = float2Hex(rainfall);            // 2 - 2 enteros
        centibarh = float3dHex(centibar);           // 3 - 2 enteros, 1 dec
        windDirh = float3dHex(windDir);             // 3 - 2 enteros, 1 dec
        windSpeedh = float3Hex(windSpeed);          // 3 - 3 enteros
        maxWindSpeedh = float3Hex(maxWindSpeed);    // 3 - 3 enteros
        //Creo las cadenas de Hex
        snprintf(buffer1, 12, "%s%s%s%s", rainfallh, windDirh, windSpeedh, maxWindSpeedh); //con %.4s puedo definir cuantos caracteres se pasan
        snprintf(buffer2, 12, "%s%s%s%s", centibarh, VWC10HSh, VWCEC5h, lightLvlh);
        snprintf(buffer3, 12, "%s,%s,%s", tempDS18B20h, tempdht22h, humdht22h);
        wait(5.0f);
    }
}

/*


Las definiciones de la placa tienen que estar como externas, para poder exportar el ejemplo e integrarlo con otros (algo así como el marlin) hay ejemplos
de como se hace
*/
void ReadSensors()
{
    lightLvl = readLightSensor(light,lightref);     //Sensor de Luz
    VWC10HS = Moist10HS(moisture10HS);              //Sensor 10HS
    VWCEC5 = MoistEC5(moistureEC5);                 //Sensor EC-5
    tempdht22 = dht22.ReadTemperature(CELCIUS);     //Sensor DHT22
    humdht22 = dht22.ReadHumidity();                //Sensor DHT22
    centibar = Moist200ss(moisture200ss);           //Sensor WaterMark 200ss
    CWeatherMeters::SMeasurements Measurements;     //Weather Station
    WeatherMeters.GetMeasurements(&Measurements);   //Weather Station
    rainfall = Measurements.Rainfall;               //Weather Station
    windSpeed = Measurements.WindSpeed;             //Weather Station
    maxWindSpeed = Measurements.MaximumWindSpeed;   //Weather Station
    windDir = Measurements.WindDirectionAngle;      //Weather Station
    ConvT();                        // Todos los DS18B20 inician la conversión a temp
    wait_ms(750);                   // Tiempo minimo de conversion a 12-bit
    for(int i=1; i<=numROMs; i++) { // Bucle para todos los DS18B20
        tempDS18B20 = Get_Temp(i);
        pc.printf("DS18B20 Temp: %08.4f Device: %02X%02X%02X%02X%02X%02X %03d\r\n",tempDS18B20,FoundROM[i][6],FoundROM[i][5],FoundROM[i][4],FoundROM[i][3],FoundROM[i][2],FoundROM[i][1],i);
    }
    pc.printf("\r\n");
}

/* CALL  char *temphex = temp2Hex(dht22);


*/