
typedef struct _fcc_data {

    unsigned short US;  //2
    unsigned short IR1;          //2
    unsigned short IR2;         //2
    unsigned short IR3;         //2
    unsigned short IR4;         //2
    unsigned short bat;   //2
    char state_flag;    //1
    float roll, pitch, yaw;    // 4, 4, 4
    float g_roll, g_pitch, g_yaw;  //4, 4, 4
    float acc_x, acc_y, acc_z;   //4, 4 ,4

}FCC_DATA;
FCC_DATA fcc;

typedef struct _imu{
    char *roll, *pitch, *yaw, *g_roll, *g_pitch, *g_yaw, *acc_x, *acc_y, *acc_z;
}data_IMU;
data_IMU data;

typedef struct _ahrs {

    short packet;  //2
    unsigned char data_info;  //1
    float g_roll, g_pitch, g_yaw;  //4, 4, 4
    float acc_x, acc_y, acc_z;   //4, 4 ,4
    float roll, pitch, yaw;    // 4, 4, 4

}AHRS_DATA;
AHRS_DATA IMU;


typedef struct _gps {
    float lat, lon, alti, dist, bear;
}GPS_DATA;
GPS_DATA gps;

typedef struct _rc {
    short roll, throttle, pitch, yaw, sw;
    short rolls, throttles, pitchs, yaws, sws;
} RC_DATA;
RC_DATA RC;    

typedef struct _last{
    float roll, pitch, yaw;    // 4, 4, 4
    float g_roll, g_pitch, g_yaw;  //4, 4, 4
    float acc_x, acc_y, acc_z;   //4, 4 ,4
} LAST_IMU;
LAST_IMU last;

typedef struct _gainRoll{
    float p, i, d, r;
}GAIN_ROLL;
GAIN_ROLL gainRoll;

typedef struct _gainPitch{
    float p, i, d, r;
}GAIN_PITCH;
GAIN_PITCH gainPitch;

typedef struct _gainYaw{
    float p, i, d, r;
}GAIN_YAW;
GAIN_YAW gainYaw;

typedef struct _gainAlti{
    float p, i, d, r;
}GAIN_ALTI;
GAIN_ALTI gainAlti;


//======== PID Struct =====/
typedef struct GAIN_GET
{
     char Index, flight_mode, sensor_select; //3
     float p_gain, i_gain, d_gain, goal; //4, 4, 4, 4
     char dumm; //1 -dummy
}PID_GAIN; 
PID_GAIN PID;    


//======== F_MODE Struct =====/
typedef struct F_MODE_GET
{    
     unsigned short mode;
     ///char lock, mode, mission; //1, 1, 1
    // unsigned short heading_ref; //2
    // unsigned short alti_ref; //2
   ///  unsigned short y_trim; //2
    /// unsigned short r_trim; //2
   ///  unsigned short p_trim; //2    
     //char dumm; //1 -dummy 
}F_MODE_DATA; 
F_MODE_DATA FMD;

