#include "mbed.h"
#include "define.h"
#include "setup.h"
#include "struct.h"

int loop_cnt = 0, init_cnt = 0;

#include "pid.h"
#include "i2c.h"
#include "rc.h"

#include "2gcs.h"
#include "gps.h"
#include "2fcs.h"

#include "ahrs.h"

void init(){
    Yaw_ref = fcc.yaw;
    init_cnt++;
}    
    
int main() {
    setup();
    securinit();     
    rc.rise(&PPM_rise);    // attach the address of the PPM_rise function to the rising edge   
    wait(0.5);
    
    while(1) {           // wait around, interrupts will interrupt this!        
        if(ahrs.readable())ahrs_rec();
        
        if(radio.readable())radio.putc(radio.getc());//getGCS();
        if(loop_cnt>10000){
            getrc();
            pid();
            moteq();
            updatei2c();        
            loop_cnt = 0;   
            //rcprint();               
            if(bat > 0.8) myled = 1;
            else myled = !myled;
        }   
        loop_cnt++;                  
       
    }
}

   