/*
Servo Calibration
*/
#include "servocalibration.h"


Servo testServo(D5);
Serial pcServo(USBTX, USBRX);

int calibMain() {
    printf("Servo Calibration Controls:\n");
    printf("1,2,3 - Position Servo (full left, middle, full right)\n");
    printf("4,5 - Decrease or Increase range\n");

    float range = 0.000650;
    float position = 0.5;
    
    while(1) {                   
        switch(pcServo.getc()) {
            case '1': position = 0.0; break;
            case '2': position = 0.5; break;
            case '3': position = 1.0; break;
            case '4': range += 0.000005; break; 
            case '5': range -= 0.000005; break; 
        }
        printf("position = %.1f, range = +/-%0.6f\n", position, range);
        testServo.calibrate(range, 45.0);
        testServo = position;
    }
}
