/*
Header file for JAGBot main.cpp
*/

#include "mbed.h"

#include "FastMath.h"
#include <math.h>

#include "Servo.h"
#include "PPM.h"
#include "UM7.h"
//#include "UM6.h"
//#include "servocalibration.h"
//#include "CANTest.h"
//#include "RCTest.h"
//#include "IMUTest.h"

//------------------    Debug Mode
#define SERVOTEST 0
#define CANTEST 0
#define RCTEST 0
#define IMUTEST 0

#define USESERIAL 1

//------------------    RC Calibration Constants
#define LUD_MIN     -1
#define LUD_MAX     112
#define LRL_MIN     -1
#define LRL_MAX     112
#define RRL_MIN     -1
#define RRL_MAX     112

#define DEADBAND    10 //Percent

#define CONTROL_MODE 4
//0 means don't do anything
//1 means skid steer
//2 means quasi-omni
//3 means Aerial Control only
//4 means State Machine with quasi-omni + Aerial Control
                        

//------------------    Mathematical Constants
#define DEG2ENC 16384.0/360.0
#define PI 3.14159265359
#define ENC2DEG 360.0/16384.0
#define DEG2RAD ((2.0*PI)/360.0)
#define RAD2DEG (1/(DEG2RAD))
#define KT  0.45
#define KV  (1/KT)


//------------------    Implementation Constants
#define FREQ 1000.0
#define PERIOD (1.0/FREQ)

#define SERIAL_FREQ 250
#define SERIAL_PERIOD 1.0/SERIAL_FREQ
#define SERIAL_RATIO (FREQ/SERIAL_FREQ)

bool isRunning = 1;
long teleCounter = 0;
long loopCounter = 0;

Timer timer;
double t = 0; 
double tAirStart = 0;
double dt = 0;
double tPrev = 0;
int badTime = 0;

bool inInt = 0; //Are we in an interrupt?

//PPM object
PPM *ppmInputs;
InterruptIn *PPMinterruptPin = new InterruptIn(D12);
//Array to hold RC commands
float rcCommandInputsRaw[8] = {0,0,0,0,0,0,0,0};
float rcCommandInputs[8] = {0,0,0,0,0,0,0,0};

Servo myservo0(D2);
Servo myservo1(D3);
Servo myservo2(D4);
Servo myservo3(D5);

Servo odrv0axis0(D8);
Servo odrv0axis1(D7);
Servo odrv1axis0(D10);
Servo odrv1axis1(D6);

float eulerTimeAvg;
double pitchAvg;
double rollAvg;
double yawAvg;
double rollDotAvg;
double pitchDotAvg;
double yawDotAvg;
double accXAvg;
double accYAvg;
double accZAvg;

double Tx;
double Ty;

int state = 0; // 0 is quasi-omni steer, 1 is aerial balance

double odrvCmds[4] = {0,0,0,0};

double debugVal = 0;
double lastCommand[8] = {0,0,0,0,0,0,0,0};

//Serial pcSerial(PC_10, PC_11);
Serial pcSerial(USBTX, USBRX);

void getRCInputs();
void loop();
void setup();
void setupServo();