#include "TouchEventListener.h"

TouchEventListener::TouchEventListener(){
    debug = false;    
}

bool TouchEventListener::hasEvent()
{
    bool ret = false;
    TS_StateTypeDef TS_State;
    ts.GetState(&TS_State);


    if (TS_State.touchDetected) {
        ret = true;
        lastEvent = new TouchEvent(TS_State.touchX[0], TS_State.touchY[0]);
    }

    if(debug) {
        uint8_t text[30];
        sprintf((char*)text, "Touch : x=%d y=%d    ", this->lastEvent->getX(), this->lastEvent->getY() );
        //lcd.ClearStringLine(0);
        lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
    }
    
    return ret;
}

TouchEvent* TouchEventListener::getEvent()
{
    return lastEvent;
}

void TouchEventListener::setDebug(bool debug)
{
    this->debug = debug;
    lcd.ClearStringLine(0);
}