#include "mbed.h"
#include "EC.h" //ヘッダファイルをインクルード
SpeedControl motorR(PC_1,PC_0,500,0.05,PB_7,PB_0); //エンコーダ分解能1024、角速度計算間隔を0.05秒に設定
SpeedControl motorL(PC_2,PC_3,500,0.05,PA_0,PA_1);
Ticker ticker;  //角速度計算用ticker
DigitalIn button(USER_BUTTON);
Serial pc(USBTX,USBRX);
SPISlave spi(PA_7, PA_6, PA_5, PA_4); // mosi, miso, sclk, ssel
PwmOut  Servo(PC_7);
#ifndef M_PI
#define M_PI 3.14159126f
#endif
int kai=0,round=0,a=0, d1=920,d2=920;

int resolution=500;

double start=0,now=0,yaw=0,ave1=0,ave2=0,ave3=0;


double diameterR=79.47f; //右輪直径
double diameterL=79.42f; //左輪直径
double diameter=(diameterR+diameterL)/2;

void calOmega() //角速度計算関数
{
    motorL.CalOmega();
    motorR.CalOmega();
}

void degreecount()
{
    if(spi.receive()) {
        unsigned short data = spi.read();
        yaw = (double)data / 10000 * 180 / M_PI;
        //pc.printf("gyro state:%lf\n\r", yaw);
    }
}

void degreearrange()
{
    now=yaw-start;
    if(now<0) {
        now=360+now;
    }
    if(now>180) {
        now=now-360;
    }
}

int main()
{
    Servo.period_ms(20);
    Servo.pulsewidth_us(1150);
    ticker.attach(&calOmega,0.05);      //0.05秒間隔で角速度を計算
    motorL.setPIDparam(0.15,0.0,0.15);  //PIDパラメータを設定
    motorL.setDOconstant(39.74);         //duty比と角速度の変換係数を46.17に10-39.74 20-
    motorR.setPIDparam(0.15,0.0,0.15);  //PIDパラメータを設定
    motorR.setDOconstant(36.761);         //duty比と角速度の変換係数を35.261,10-36.761 20-36.761
    spi.format(16,3);
    spi.frequency (1000000);
    while(1) {
        degreecount();
        if(a==0) {
            a++;
            wait_ms(100);
        } else if(a<101) {
            start+=yaw;
            wait_ms(100);
            a++;
        }
        if(a==101) {
            start/=100;
            a++;
        }

        else if(a>101) {
            int countL=motorL.getCount();
            int countR=motorR.getCount();
            double ave=(countL+countR)/2;
            degreearrange();
            if(round==0) {
                if(ave<=resolution*d1/(diameter * M_PI)) {
                    Servo.pulsewidth_us(1150);
                    motorL.Sc(8);     //角速度10rad/sで逆回転
                    motorR.Sc(8);
                    if(kai>=50) {      //ループ500回ごとに角速度・出力duty比を表示
                        pc.printf("omegaL=%f,omegaR=%f\r\n\t",motorL.getOmega(),motorR.getOmega());
                        kai=0;
                    }
                } else {
                    round++;
                    motorR.Sc(0);
                    motorL.Sc(0);
                    wait(0.5);
                    ave1=ave;
                }
            }
            if(round==1) {
                ave-=ave1;
                if(ave>=-resolution*d2/(diameter * M_PI)) {
                    motorL.Sc(-8);     //角速度10rad/sで逆回転
                    motorR.Sc(-8);
                    if(kai>=50) {      //ループ500回ごとに角速度・出力duty比を表示
                        pc.printf("omegaL=%f,omegaR=%f\r\n\t",motorL.getOmega(),motorR.getOmega());
                        kai=0;
                    }
                } else {
                    round++;
                }
            }
            if(round==2) {
                motorR.Sc(0);
                motorL.Sc(0);
            }
            if(!button) break;  //ボタンを押したら停止
            kai++;
        }
        motorL.stop();
        motorR.stop();
    }
}