//Talking GSM Braille-Input SMS

#include "mbed.h"
#include "MODSERIAL.h"
#include <math.h>
#include <iostream>
#include <string>
#include <stdlib.h>
#include <ctype.h>
#include "Braille_In.h"
#include "PinDetect.h"
#define MESSAGE_BUFFER_SIZE 1024
using namespace std;

// OPTIONAL SETTINGS

int SMSinterval = 15;       //Send a SMS Vote once every n seconds
string phoneNumber = "16783503079";    //Phone Number to send SMS Votes
string bodyText = "Buzz";    //Message to send in vote

//END OF OPTIONAL SETTINGS


//MODSERIAL gsm(p28,p27);
//Serial pc(USBTX, USBRX); // PC Virtual Serial Port over USB

MODSERIAL gsm(USBTX,USBRX);
MODSERIAL pc(p28, p27);
Serial speakjet(p13,p14);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DigitalOut dot1LED(p5);
DigitalOut dot2LED(p26);
DigitalOut dot3LED(p25);
DigitalOut dot4LED(p30);
DigitalOut dot5LED(p29);
DigitalOut dot6LED(p6);

BrailleInput bparse;
InterruptIn dot1(p15);
InterruptIn dot2(p16);
InterruptIn dot3(p17);
InterruptIn dot4(p18);
InterruptIn dot5(p23);
InterruptIn dot6(p24);
PinDetect dotSp(p21);
char ExampleSentance[] = { 0x20, 0x3,  0x17, 0x1, 0xA, 0x7, 0x7, 0x11, 127, 0x1E, 0x11, 0x2D,0x1E, 127, 0xA, 0xE, 127, 0x1, 0x3A, 0x11, 0x0E, 0x15, 0xD, 0x11, 0x16, '\0' };
PinDetect SendSMS(p22);

int SMScount = 0;
int timeCount;
int statusMessage = 0;
int compareResult = 0;
int messageResponse = 0;
int mpResult = 0;
bool timeOrDate = 0;
bool statusMessageAlert = 0;
bool statusMessageInterrupt = 0;
char messageBufferIncoming[MESSAGE_BUFFER_SIZE];
char messageBufferOutgoing[MESSAGE_BUFFER_SIZE];
bool messageReceived;

char braillein[256];
char buf[40];
char buf1[40];
char buf2= 0x1A;    //CTRL+Z, Substitute character

bool sendMsgDesired=false;
bool InputDone=false;
bool SMS_Rcv=false;
bool SMS_Header_Rcv=false;
int SMS_Rcv_loc=0;
char paranoidWasteBuf[25];
char messageHeader[400];

char currentBrailleChar=0;
string BrailleIn=" ";

void ledCellRefresh()
{
    dot1LED=currentBrailleChar & 0x1;
    dot2LED=currentBrailleChar & 0x2;
    dot3LED=currentBrailleChar & 0x4;
    dot4LED=currentBrailleChar & 0x8;
    dot5LED=currentBrailleChar & 0x10;
    dot6LED=currentBrailleChar & 0x20;
   }

void setLEDs(int in)
{
    switch (in){
        case 1:
            led1=0;  led2=0;  led3=0;  led4=1;
            break;
        case 2:
            led1=0;  led2=0;  led3=1;  led4=0;
            break;
        case 3:
            led1=0;  led2=0;  led3=1;  led4=1;
            break;
        case 4:
            led1=0;  led2=1;  led3=0;  led4=0;
            break;
        case 5:
            led1=0;  led2=1;  led3=0;  led4=1;
            break;
        case 6:
            led1=0;  led2=1;  led3=1;  led4=0;
            break;
        case 7:
            led1=0;  led2=1;  led3=1;  led4=1;
            break;
        case 8:
            led1=1;  led2=0;  led3=0;  led4=0;
            break;
        case 9:
            led1=1;  led2=0;  led3=0;  led4=1;
            break;
         default:
            led1=0; led2=0; led3=0; led4=0;
         }
         ledCellRefresh();
         }
            

    

void d1(){ currentBrailleChar = currentBrailleChar | 0x01; setLEDs(1);}
void d2(){ currentBrailleChar = currentBrailleChar | 0x02; setLEDs(2);}
void d3(){ currentBrailleChar = currentBrailleChar | 0x04; setLEDs(3);}
void d4(){ currentBrailleChar = currentBrailleChar | 0x08; setLEDs(4);}
void d5(){ currentBrailleChar = currentBrailleChar | 0x10; setLEDs(5);}
void d6(){ currentBrailleChar = currentBrailleChar | 0x20; setLEDs(6);}
void dSp(){ 
if (currentBrailleChar==0) currentBrailleChar=127;
BrailleIn+=currentBrailleChar;
currentBrailleChar=0;
setLEDs(7);
}
void select_SMS_Send() { sendMsgDesired=true;  setLEDs(8); }
void select_SMS_Held() { InputDone=true; BrailleIn+=currentBrailleChar; currentBrailleChar=0;setLEDs(9);}


string extract_first_num(string in)
{
    int firstnum = in.find_first_of("123456789");
    string out="";
    while ( isdigit(  in[firstnum] ) )
    {
        out+=in[firstnum];
        firstnum++;
     }
     return out;
}

string getBrailleInput()
{
  string BrailleOut = bparse.translateBraille(BrailleIn.c_str(),BrailleIn.length());
  pc.printf("getBrailleInput\t %s\n",BrailleOut.c_str());
  return BrailleOut;
}   

string Braille_Letters_Numbers(string in)
{
    string out = in;
    char c,d;
    pc.printf("Braille_Letters_Numbers %s\n",in.c_str());
    for (int i=0; i<in.length()-1; i++)
    {
        c = in[i];
        switch (c){
            case 'a':
                d='1';
                break;
            case 'b':
                d='2';
                break;
            case 'c':
                d='3';
                break;
            case 'd':
                d='4';
                break;
            case 'e':
                d='5';
                break;
            case 'f':
                d='6';
                break;
            case 'g':
                d='7';
                break;
            case 'h':
                d='8';
                break;
            case 'i':
                d='9';
                break;
            case 'j':
                d='0';
                break;
            }
           
            out[i]=d;
            
           }     
       out[in.length()-1]='\0';    
    pc.printf(out.c_str());
    return out;
 }


void speak(string input)
{
    //stub to be replaced w/ speakjet code
    speakjet.printf("\t%s\n",input);
    //ctrl.printf("%s\n",input);
    
}


void messageReceive(MODSERIAL_IRQ_INFO *q) {
    MODSERIAL *sys = q->serial;
    
   sys->move(messageBufferIncoming, MESSAGE_BUFFER_SIZE);
    
    messageReceived = true;
    return;
}

int messageProcess(void) {
    string msgbufstr(messageBufferIncoming); 
    string temp;
    
  if (!strncmp(messageBufferIncoming, "+CMTI:",sizeof("+CMTI:")-1)) 
    {
        SMS_Rcv=true;
        temp = extract_first_num(msgbufstr);
        SMS_Rcv_loc = atoi(temp.c_str());
       
     }
     
     
     
        
    
    if (!strncmp(messageBufferIncoming, "OK", sizeof("OK")-1)) mpResult = 1;
    else if (!strncmp(messageBufferIncoming, "ERROR", sizeof("ERROR")-1)) mpResult = 2;
    else mpResult = 1;
    
    pc.printf("%s\r\n", messageBufferIncoming);
     gsm.rxBufferFlush();                            //Flush the Buffer
    messageReceived = false;
    return mpResult;
}

void send_SMS() {
    //Send SMS
    
    gsm.printf("AT+CMGS=\"%s\"\r\n", phoneNumber);
    wait(.5);
    gsm.printf("%s%c\r\n", bodyText, buf2);
    wait(.5);
    
    if (messageProcess()==1) {
        statusMessageAlert = 1;
        statusMessage = 5;
        SMScount = SMScount + 1;
        pc.printf("SMS sent: %d\r\n", SMScount);
    } else {
        statusMessageAlert = 1;
        statusMessage = 7; //This value will also force a auto re-send
        pc.printf("SMS send failed\r\n");
    }
}



void RetreiveSMS(int smsLoc)
{
    char * messageHeader2;
    char command[20];
    gsm.autoDetectChar('\a');
    wait(.5);
    sprintf(command,"AT+CMGR=%d\r\n",smsLoc);
    gsm.printf(command);
    wait(2);
    int i=0;
    while(gsm.readable())
    {
        messageHeader[i]=gsm.getc();
        i++;
    
    
    
    }
    messageHeader[i]='\0';
    
    
    wait(.5);
    sprintf(command,"AT+CMGD=%d\r\n",smsLoc);
    gsm.printf(command);
    wait(.5);
    gsm.rxBufferFlush();
    wait(0.2); 
    
    SMS_Rcv=false;
    SMS_Header_Rcv=false;
  
    gsm.autoDetectChar('\n');
    wait(1);
    
    messageHeader2=strtok(messageHeader,"\n");
   //under here getting SMS header
    messageHeader2=strtok(NULL,"\n");
    string SMS_Hdr(messageHeader2);
    //Under here getting SMS body?
    messageHeader2=strtok(NULL,"\n");
    string Rcv_PhoneNum=extract_first_num(SMS_Hdr);
    string SMS_Body(messageHeader2);
    SMS_Body.erase(SMS_Body.find_last_not_of(" \n\r\t")+1); 
    Rcv_PhoneNum.erase(Rcv_PhoneNum.find_last_not_of(" \n\r\t")+1); 

    
   
    //gsm.printf(Rcv_PhoneNum.c_str());
    gsm.printf("AT\r\n");
    
    wait(.2);
    
    speak("Incoming SMS from ");
    speak(Rcv_PhoneNum);
    wait(.5);
    speak(SMS_Body);
    wait(1);
     
        
    phoneNumber=Rcv_PhoneNum;
    bodyText=SMS_Body;
    
  
    messageProcess();

    
}





int main() {
    messageReceived = false;
    gsm.baud(19200);
    gsm.format(8, Serial::None, 1);
    gsm.attach(&messageReceive, MODSERIAL::RxAutoDetect);     //Attaches Interrupts
    gsm.autoDetectChar('\n');                                 //Set Detection to Line Feed
    pc.baud(19200);
    speakjet.baud(9600);
    wait(2);
    
    
    dot1.mode(PullUp);
    dot2.mode(PullUp);
    dot3.mode(PullUp);
    dot4.mode(PullUp);
    dot5.mode(PullUp);
    dot6.mode(PullUp);
    dotSp.mode(PullUp);
    SendSMS.mode(PullUp);
    wait(0.01);
    dot1.fall(d1);
    dot2.fall(d2);
    dot3.fall(d3);
    dot4.fall(d4);
    dot5.fall(d5);
    dot6.fall(d6);
    dotSp.setAssertValue( 0 );
    dotSp.attach_asserted( dSp );
    SendSMS.setAssertValue(0);
    SendSMS.attach_asserted(select_SMS_Send);
    SendSMS.attach_asserted_held( select_SMS_Held );

    dotSp.setSampleFrequency();
    SendSMS.setSampleFrequency();
    
    
    
    // Set-UP GSM Modem

    speak("Welcome to S M S Braille O Tron!");
    wait(1);
    pc.printf("Setting up GSM Modem\r\n");
    pc.printf("GSM Modem Setup");
    wait(1);
    gsm.printf("AT\r\n");
    wait(0.5);
    messageProcess();
    
    wait(1);
    string ExStr = ExampleSentance;
    bodyText = bparse.translateBraille(ExStr.c_str(),ExStr.length());
    //send_SMS();
    wait(4);
    gsm.printf("AT\r\n");
    wait(0.5);
    messageProcess();
    while (1) {
   
    
    if (SMS_Rcv) 
    {
       // pc.printf("SMS RCV\n");
       messageProcess();
        RetreiveSMS(SMS_Rcv_loc);
        wait(2);
        send_SMS();
    }
    
     
    
      
    if (sendMsgDesired)
    {
    speak("Enter Phone Number: ");
    BrailleIn="a";
    BrailleIn[0]=0x1;
    while (!InputDone){ wait(.5);}
    InputDone=false;
    phoneNumber = getBrailleInput();
    phoneNumber = extract_first_num(Braille_Letters_Numbers(phoneNumber));
    BrailleIn=" ";
    BrailleIn[0]=127;
    speak("Enter Message Text: ");
    while (!InputDone){wait(.5);}
    
    InputDone=false;
    bodyText= getBrailleInput();
    wait(.5);
    send_SMS();
    wait(1);
    sendMsgDesired=false;
    }
    
          
  //  gsm.printf("AT\r\n");                     //Check Connection
    wait(0.5);
    wait(1);
    messageProcess();    
    wait(.5);
    
    wait(5);     
    
                     //Process incoming message
    }
    
    
    
 
    return 0;
}