//WavePlayer_HelloWorld4180
//internet_clock

#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "uLCD_4DGL.h"
#include "rtos.h"
#include "PinDetect.h"
#include "HTTPClient.h"

//pinouts
// Graphic LCD - TX, RX, and RES pins
uLCD_4DGL uLCD(p28,p27,p29);
SDFileSystem sd(p11, p12, p13, p14, "sd"); //SD card
AnalogOut DACout(p18);
wave_player waver(&DACout);
PinDetect snooze(p19);  //snooze button
PinDetect off(p20);     //turn alarm off
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
//Mutex lcd_mutex;

// Parameters
char* time_domain_name = "0.uk.pool.ntp.org";
//char* weth_domain_name = "http://weather.yahooapis.com/forecastrss?w=2502265";
//char* weth_domain_name = "https://query.yahooapis.com/v1/public/yql?q=select%20item.condition%20from%20weather.forecast%20where%20woeid%20in%20%28select%20woeid%20from%20geo.places%281%29%20where%20text%3D%22atlanta%2C%20ga%22%29&format=json&env=store%3A%2F%2Fdatatables.org%2Falltableswithkeys";
char* weth_domain_name = "https://query.yahooapis.com/v1/public/yql?q=select%20item.condition%20from%20weather.forecast%20where%20woeid%20in%20%28select%20woeid%20from%20geo.places%281%29%20where%20text%3D%22atlanta%2C%20ga%22%29&format=json&env=store%3A%2F%2Fdatatables.org%2Falltableswithkeys";
int port_number = 123;

// Networking
EthernetInterface eth;
NTPClient ntp_client;

#define snoozeTime 10

//global variables
time_t ct_time;
// Base alarm time-24 hour clock
int baseAlarmHour = 0; //0-23
int baseAlarmMin = 0;
// Current alarm time
int curAlarmHour = 18; //0-23
int curAlarmMin = 9;
bool play = true;

//time thread
void time_thread(void const *args)
{
    char time_buffer[80];
    // Loop and update clock
    while (1) {
        //lcd_mutex.lock();
        uLCD.locate(0, 1);
        ct_time = time(NULL);
        strftime(time_buffer, 80, "    %a %b %d\n    %T %p %z\n    %Z\n", \
                 localtime(&ct_time));
        uLCD.printf("    UTC/GMT:\n%s", time_buffer);
        //lcd_mutex.unlock();
        Thread::wait(100);
    }
}

void parseWeather(char* buf)
{
    char * pch;
    char * key;
    pch = strtok (buf,"{");
    while (pch != NULL) {
        pch = strtok (NULL,"{");
    }
    pch = strtok (buf,",");
    while (pch != NULL) {
        key = strtok (pch,":");
        if(strcmp(key, "\"text\"")) {
            uLCD.printf("Condition = %s",pch);
        } else if(strcmp(key, "\"temp\"")) {
            uLCD.printf("temp = %s",pch);
        }
    }
}

void getWeather()
{
    //lcd_mutex.lock();
    /*** WEATHER****/
    char buf[500];
    uLCD.printf("Getting weather..\n");
    HTTPClient http;
    int retHttp = http.get(weth_domain_name, buf, sizeof(buf));
    uLCD.printf("%d", retHttp);
    switch(retHttp) {
        case HTTP_OK:
            uLCD.printf("Read completely\n");
            uLCD.printf("%c",buf);
            wait(2);
            uLCD.printf("%s",buf);
            wait(2);
            parseWeather(buf);
            break;
        case HTTP_TIMEOUT:
            uLCD.printf("Connection Timeout\n");
            break;
        case HTTP_CONN:
            uLCD.printf("Connection Error\n");
            break;
        default:
            uLCD.printf("Error\n");
    }
    //lcd_mutex.unlock();
}

void weth_thread(void const *args)
{

    Thread::wait(3600000);
}

//pushbutton (p19)
void snooze_hit_callback (void)
{
    myled1 = !myled1;
    play = false;
    time_t newtime;
    struct tm * timeinfo;
    newtime = ct_time + snoozeTime;
//time (&newtime);
    timeinfo = localtime (&newtime);
    curAlarmMin = timeinfo->tm_min;
    curAlarmHour = timeinfo->tm_hour;
}

void off_hit_callback (void)
{
    myled2 = !myled2;
    play = false;
    curAlarmMin = baseAlarmMin;
    curAlarmHour = baseAlarmHour;
}

void play_file()
{
    bool* play_point = &play;
    FILE *wave_file;
    printf("\n\n\nHello, wave world!\n");
    wave_file=fopen("/sd/bob.wav","r");
    waver.play(wave_file, play_point);
    fclose(wave_file);
}

void timeCompare()
{
    struct tm * timeinfo;
    timeinfo = localtime (&ct_time);
    if (timeinfo->tm_min == curAlarmMin && timeinfo->tm_hour == curAlarmHour) {
        play = true;
        myled3 = true;
        play_file();
    }
}

int main()
{
    snooze.mode(PullUp);
    off.mode(PullUp);
    wait(0.01);
    snooze.attach_deasserted(&snooze_hit_callback);
    off.attach_deasserted(&off_hit_callback);
    snooze.setSampleFrequency();
    off.setSampleFrequency();

    //play_file();


    // Initialize LCD
    uLCD.baudrate(115200);
    uLCD.background_color(BLACK);
    uLCD.cls();

    // Connect to network and wait for DHCP
    uLCD.locate(0,0);
    uLCD.printf("Getting IP Address\n");
    eth.init();
    if ( eth.connect(60000) == -1 ) {
        uLCD.printf("ERROR: Could not\nget IP address");
        return -1;
    }
    uLCD.printf("IP address is \n%s\n\n",eth.getIPAddress());
    Thread::wait(1000);
    getWeather();
    wait(500);
    // Read time from server
    uLCD.printf("Reading time...\n\r");
    ntp_client.setTime(time_domain_name, port_number);
    uLCD.printf("Time set\n");
    Thread::wait(2000);
    eth.disconnect();

    // Reset LCD
    uLCD.background_color(WHITE);
    uLCD.textbackground_color(WHITE);
    uLCD.color(RED);
    uLCD.cls();
    uLCD.text_height(2);

    //Thread t1(time_thread);
    //Thread t2(weth_thread);
    while(true) {
        timeCompare();
        Thread::wait(100);
    }

}