
#include "mbed.h"
#include "ESP8266.h"               // Include header file from Author: Antonio Quevedo
#include "math.h"
#include <string>

#define APIKEY 45IE5JPN8ZIK2W2M    //Put "Write key" of your channel in thingspeak.com 
#define IP "184.106.153.149"       // IP Address of "api.thingspeak.com\"
#define WIFI_SSID "Redmi"
#define WIFI_PASS "akash12345"

Serial pc(USBTX,USBRX);
SPI spi(PTC6,PTC7,PTC5); // (MOSI MISO CLK)setup SPI interface on pins PTC5,PTC6,PTC7
ESP8266 esp(PTC17, PTC16, 115200); // baud rate for wifi

DigitalOut cs1(PTC4);
DigitalOut cs2(PTC3);
I2C i2c(PTD9,PTD8);

//AnalogIn check(PTB6);
const int addr = 0x88;

char snd[255],rcv[1000],snd_Data[255];           //snd= string used to send command to ESP 8266 wii and  rcv = string used to receive response from ESP8266 wifi module  

int cnt = 0;                       // counter for  number of motion detected
int cnt1 = 0;                       // counter for  number of motion detected
int cnt2 = 0;                       // counter for  number of motion detected

float ammeter_out = 0;
float voltmeter_out = 0;
float light_out = 0;

void esp_initialize(void); // Function used to initialize ESP8266 wifi module 
void esp_send(void);       // Function used to connect with thingspeak.com and update channel using ESP8266 wifi module 

int main() 
{
    
    pc.baud(115200);           // Baud rate used for communicating with Tera-term on PC
    
    pc.printf("START\r\n");  // Starting point
    
    esp_initialize();
    
    //ammeter + voltmeter code
    spi.format(8,0);
    spi.frequency(1000000);
    pc.printf("Analog read test from spi.\n");
    pc.printf("\n\r");
    
    //light code
    int exp,exp1,l=1;
    i2c.frequency(100000); // set required i2c frequency
    //pc.baud(9600); //set baud rate
    pc.printf("I2C started!\r\n");
    pc.printf("\n\r");
    char cmd[3]; //for byte transfer

    while (1) 
    {
        wait(15);
        //ammeter code
    
        cs1=0;
        //spi.write();
        //pc.printf("%d\r\n",k);
        int high_byte = spi.write(0);
        int low_byte = spi.write(0);
        cs1=1;
        float m = ((high_byte & 0x1f) << 7) | ((low_byte >> 1));    
        float k= (float)((m*1)/4096); // show value in volts. 
        ammeter_out = (float)((k-0.5)*1000);
        pc.printf("Current value:            %f mA\r\n", ammeter_out);
        //pc.printf("Analog Value of current : %.2f\n\r",m);
        wait_ms(100);
        
        cs2=0;
        //spi.write();
        //pc.printf("%d\r\n",k);
        int hi_byte = spi.write(0);
        int lo_byte = spi.write(0);
        cs2=1;
        float x = ((hi_byte & 0x1f) << 7) | ((lo_byte >> 1));
        
        float r= (float)((x*33)/4096); // show value in volts.
        voltmeter_out = (float)(r-16.5);
        pc.printf("AD Voltage channel value: %f V\r\n", voltmeter_out);
        //pc.printf("Voltage Analog Value: %.2f\n\r",x);
        wait_ms(100);
        
         //ambient light sensor code
        
        cmd[0] = 0x01;   //configuration register
        cmd[1]= 0xCC;    //configuration data
        cmd[2]= 0x01;   //configuration data
        i2c.write(addr, cmd, 3);
        cmd[0] = 0x00; // data register
        i2c.write(addr, cmd, 1);
        wait_ms(100);
        i2c.read(addr, cmd, 2);
     
        exp= cmd[0]>>4;
        exp1= (cmd[0]-(exp<<4))*256+cmd[1];
       // pc.printf("exponent = 0x%x\n\r", exp);
       // pc.printf("fraction = %d\n\r", exp1);
        l=1;
        for(int r=0;r<exp;r++){l=l*2;};
          //  pc.printf("value = %d\n\r", l);
        light_out= (exp1*l)/100;
        pc.printf("Lux = %.2f\n\r", light_out);  // printing LUX value
        pc.printf("\n\r");
        wait_ms(100); 
        
        pc.printf("Sending this information to thingspeak.com = %d\r\n",cnt);
        esp_send(); 
        
    }
}


void esp_initialize(void)
{    
    pc.printf("Initializing ESP\r\n"); 
      
    pc.printf("Reset ESP\r\n"); 
    esp.Reset();                   //RESET ESP
    esp.RcvReply(rcv, 400);        //receive a response from ESP
    //pc.printf(rcv);          //Print the response onscreen 
    wait(2);
    
    strcpy(snd,"AT");
    esp.SendCMD(snd);
    pc.printf(snd);
    //wait(2);
    esp.RcvReply(rcv, 400);       
    pc.printf(rcv);      
    wait(0.1);
    
    strcpy(snd,"AT+CWMODE=1");
    esp.SendCMD(snd);
    pc.printf(snd);
    wait(2);

    strcpy(snd,"AT+CWJAP=\"");
    strcat(snd,WIFI_SSID);
    strcat(snd,"\",\"");
    strcat(snd,WIFI_PASS);
    strcat(snd,"\"");
    
    esp.SendCMD(snd);
    pc.printf(snd);
    wait(5);
    esp.RcvReply(rcv, 400);       
    pc.printf("\n %s \n", rcv); 
    
    strcpy(snd,"AT+CIPMUX=0");
    esp.SendCMD(snd);
    pc.printf(snd);
    //wait(2);
    esp.RcvReply(rcv, 400);       
    pc.printf("\n %s \n", rcv); 

}


void esp_send(void)
{
   
    //ESP updates the Status of Thingspeak channel//
    
    strcpy(snd,"AT+CIPSTART=");
    strcat(snd,"\"TCP\",\"");
    strcat(snd,IP);
    strcat(snd,"\",80");
    
    esp.SendCMD(snd); 
    pc.printf("S\r\n%s",snd);
    //wait(2);                                                    
    esp.RcvReply(rcv, 1000);
    pc.printf("R\r\n%s",rcv);
    wait(1);
    
    sprintf(snd,"GET https://api.thingspeak.com/update?key=45IE5JPN8ZIK2W2M&field1=%f&field2=%f&field3=%f\r\n",ammeter_out,voltmeter_out,light_out);
    
    int i=0;
    for(i=0;snd[i]!='\0';i++);
    i++;
    char cmd[255];
    
    sprintf(cmd,"AT+CIPSEND=%d",i);                                       //Send Number of open connection and Characters to send 
    esp.SendCMD(cmd);
    pc.printf("S\r\n%s",cmd);
    while(i<=20 || rcv == ">")
    {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("R\r\n%s",rcv);
    
    esp.SendCMD(snd);                                                      //Post value to thingspeak channel
    pc.printf("S\r\n%s",snd);
    
    while(i<=20 || rcv == "OK")
    {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("R\r\n%s",rcv);
    
}

