
#include "mbed.h"
#include "serial.h"
#include "lora.h"
#include "gps.h"


///////////////////////////////////////
// Globals variables
///////////////////////////////////////

//declaracoes gerais

InterruptIn dio0(P0_12);
DigitalIn button1(P1_11);

EventQueue queue;

void serial_post_to_queue(void);


void serial_rx(){
    if(pc.readable()){
        pc.printf("rx: %c\n", pc.getc());
    } 
    pc.attach(&serial_post_to_queue, RawSerial::RxIrq);
    return;
}
 
void serial_post_to_queue(void){
    //disable serial rx interrupt
    pc.attach(NULL, RawSerial::RxIrq);
    //enqueue the serial rx reception as a normal task
    queue.call(SerialRx);
    //queue.event(&SerialRx);
    return;
}


int main(void) {
    pc.printf("bora comecar"); 
    ///////////////////////////////////////
    // Configuration
    ///////////////////////////////////////

    
    pc.printf("init\n");
    pc.baud(9600);
    pc.printf("baud 9600");
    pc.printf("config9600\n");
    
    //enable serial rx interrupt
    //pc.attach(&serial_post_to_queue, RawSerial::RxIrq);
    wait_ms(250);
    pc.printf("waitou 250ms");

    
    //____Configuration Lora    
    Thread eventThread;
    eventThread.start(callback(&queue, &EventQueue::dispatch_forever));
 
    dio0.rise(queue.event(&print_packet)); //configure interrupt rotine ro recieve packet
    pc.attach(&SerialRx, RawSerial::RxIrq);
    setup(); //configura sx1272
    //gps_config();
    //gps_leBootMsg();
    //gps_config_gnss ();      
        
    sx1272.writeRegister(REG_OP_MODE,133); //leitura continua
    sx1272.writeRegister(REG_IRQ_FLAGS_MASK,187);//configure interrupt mask to interrupt only when a packet receive and packet envied 
 

    
    
    while(1){
    
        if (!button1){
        
           pc.printf("SENDING PING\n");
              send_data(PING); 
        wait(5);
           pc.printf("SENDING DATA\n");
              send_data(DATA);      
            }
         
        wait_ms(50);
    }

}
