#ifndef __GPS_H

#define __GPS_H

#include "mbed.h"
#include "serial.h"

#define  SYNC1       0xB5
#define  SYNC2       0x62


#define MAXIMUM_PACKET_SIZE 60

//GPS DEclaration
extern SPI spi_2; // mosi, miso, sclk
extern DigitalOut cs;
extern DigitalOut gps_reset;
extern DigitalOut gps_int;
extern DigitalOut gps_DSEL;

static int lat;
static int lon;


typedef struct
{
    uint8_t cls;
    uint8_t id;
    uint16_t len;          //Length of the payload. Does not include cls, id, or checksum bytes
    uint8_t *payload;
    uint8_t checksumA; //Given to us from module. Checked against the rolling calculated A/B checksums.
    uint8_t checksumB;
} gps_ubxPacket;

typedef struct
{
    uint32_t iTOW=0;
    uint16_t year=0;
    uint8_t month=0;
    uint8_t day=0;
    uint8_t hour=0;
    uint8_t min=0;
    uint8_t sec=0;
    int8_t valid=0;
    uint32_t tAcc=0;
    int32_t nano=0;
    uint8_t fixtype=0;
    int8_t flags=0;
    int8_t flags2=0;
    uint8_t numSV=0;
    int32_t lon=0;
    int32_t lat=0;
    int32_t height=0;
    int32_t hMSL=0;
    uint32_t hAcc=0;
    uint32_t vAcc=0;
    int32_t velN=0;
    int32_t velE=0;
    int32_t velD=0;
    int32_t gSpeed=0;
    int32_t headMot=0;
    uint32_t sAcc=0;
    uint32_t headAcc=0;
    uint16_t pDOP=0;
    int32_t headVeh;
    int16_t magDec;
    uint16_t magAcc;

    
} gps_navPVT;


extern void gps_leBootMsg();

extern void gps_le_envia_linha();                               

extern gps_ubxPacket gps_calcula_check(gps_ubxPacket Packet);

extern void send_gps_packet(gps_ubxPacket packet);

extern gps_navPVT le_nav_pvt ();

extern void send_nav_pvt();

extern void send_gps_data(uint8_t *packet, uint8_t size);

extern void wait_packet_byte (uint8_t *header, uint8_t byte);

extern void gps_wait_same_packet();

extern void gps_config_gnss();

extern void gps_print_local ();

extern void gps_get_lat_lon(int *latitude, int *logitude);

extern void gps_config();

extern int get_latitude();

extern int get_longitude();

extern int get_time();

extern gps_navPVT get_struct();

#endif