#include "mbed.h"
#include "DebouncedIn.h"
#include "hcsr04.h"

DigitalIn B_stop(PTC8); //Boton de paro de emergencia
DigitalIn B_close(PTC9); //Boton “Cerrar” de la cabina
DigitalIn B_open(PTA13); //Boton “Abrir” de la cabina

DigitalIn B_c1(PTB1); //Boton "1" de la cabina
DigitalIn B_c2(PTB0); //Boton "2" de la cabina
DigitalIn B_c3(PTA5); //Boton "3" de la cabina

DigitalIn B_p1(PTB2); //Boton piso 1
DigitalIn B_p3(PTC1); //Boton piso 3
DigitalIn B_p2u(PTB3); //Boton piso 2 arriba
DigitalIn B_p2d(PTC2); //Boton piso 2 abajo

PwmOut S_1(PTD2); //Servomotor piso 1
PwmOut S_2(PTD0); //Servomotor piso 2
PwmOut S_3(PTD5); //Servomotor piso 3

PwmOut Motor_en(PTA12); //Motor enable
DigitalOut Motor_up(PTD4); //Motor arriba
DigitalOut Motor_down(PTA4); //Motor abajo

DigitalOut Trigger(PTD3); //Trigger Ultrasonido
DigitalIn Echo(PTD1); //Echo ultrasonido
DigitalOut myled(LED1); //monitor trigger
DigitalOut myled2(LED2); //monitor echo

Serial pc(PTA2, PTA1);

int distance = 0;
int correction = 0;
Timer sonar;

int sensordist(void);
void comp(int dmeasured);

int main(){
    sonar.reset();
    sonar.start();
    while(Echo == 2){}; 
    myled=0;
    sonar.stop();
    correction = sonar.read_us();
    
    while(true){
        
        int d = sensordist();
        comp(d);
        wait_ms(50);
        
        while((B_p2u == 0)){
            pc.printf("u");
            Motor_up = 1;
            Motor_down = 0;
            Motor_en.period_ms(50);
            Motor_en.pulsewidth_us(4000);
            }
        while((B_p2d == 0)){
            pc.printf("d");
            Motor_up = 0;
            Motor_down = 1;
            Motor_en.period_ms(50);
            Motor_en.pulsewidth_us(1000);
            }
        if ((B_p2u == 1) && (B_p2d == 1)){
            pc.printf("p");
            Motor_up = 0;
            Motor_down = 0;
            }
        
        wait_ms(500);
        
        /*if((B_p1 == 0) || (B_c1 == 0)){
            pc.printf("1");
            wait(1);
            pc.printf("u");
            
            
            }
        if((B_p2d == 0) || (B_c2 == 0) || (B_p2u == 0)){
            pc.printf("2");
            wait(1);
            pc.printf("p");
            
            
            }
        if((B_p3 == 0) || (B_c3 == 0)){
            pc.printf("3");
            wait(1);
            pc.printf("d");
            
            
            }
        if((B_open == 0)){
            pc.printf("4");
            wait(1);
            }
        if((B_close == 0)){
            pc.printf("5");
            wait(1);
            }
        if((B_stop == 0)){
            pc.printf("6");
            wait(1);
            
            }
            */
        }
    
    
    }
    


int sensordist(void){
    Trigger = 1;
    myled = 1;
    myled2 = 0;
    sonar.reset();
    wait_us(10.0);
    Trigger = 0;
    myled = 0;
    while (Echo==0) {};
    myled2=Echo;
    sonar.start();
    while (Echo==1) {};
    sonar.stop();
    distance = (sonar.read_us()-correction)/58.0;
    myled2 = 0;
    return distance;    
}

void comp(int dmeasured){
    if((dmeasured <= 5)){
        pc.printf("9");
        }
    else if ((dmeasured > 5 && dmeasured <= 10)){
        pc.printf("8");
        }
    else if ((dmeasured > 10 && dmeasured <= 15)){
        pc.printf("7");
        }
    else if ((dmeasured > 15 && dmeasured <= 20)){
        pc.printf("6");
        }
    else if ((dmeasured > 20 && dmeasured <= 25)){
        pc.printf("5");
        }
    else if ((dmeasured > 25 && dmeasured <= 30)){
        pc.printf("4");
        }
    else if ((dmeasured > 30 && dmeasured <= 35)){
        pc.printf("3");
        }
    else if ((dmeasured > 35 && dmeasured <= 40)){
        pc.printf("2");
        }
    else if ((dmeasured > 40 && dmeasured <= 46)){
        pc.printf("1");
        }
    else{
        pc.printf("0");
        }
    }




