/**
@Header file name.h
@Project-D Weather Station
@file main.cpp
@author Li XingYu
@date May 2015
*/

#include "mbed.h"
#include "N5110.h"
#include "BMP180.h"

/**
@namespace lcd,bmp180,serial
@brief serial connects to micro-controller
@brief
*/

//The pins of N5110, BMP180 which are connected to micro-controller
N5110 lcd(p7,p8,p9,p10,p11,p13,p22);
BMP180 bmp180(p28,p27);
Serial serial(USBTX,USBRX);// The tool which sets the date

/**
add up one integer variable
@param setTimerFlag - integer to add
creat two functions
@param serialISR - function to add
@param setTime - function to add
*/
void serialISR();// ISR that is called when serial data is received
void setTime();// function to set the UNIX time
int setTimerFlag = 0;// flag for ISR

char rxString[16];// buffer to store received string


/**
@Boot Screen
Sset Brightness
@Set date
@Connect LCD and sensor to micro-controller
@Display temperature and pressure
*/

int main()
{

    lcd.init();
    //Boot Screen
    lcd.printString("Project-D",2,1);//First line and coordinate
    lcd.printString("Weather",2,2);//Second line and coordinate
    lcd.printString("station",2,3);//Third line and coordinate
    wait(2.0);//Wait 2 secs and turn into next interface
    lcd.clear();//Clear
    lcd.setBrightness(0.1);//Screen Brightness
    bmp180.init();
    Measurement measurement;
    //RTC
    serial.attach(&serialISR);//Set the time
    char t[30];//array to t
    while(1) {
        time_t seconds = time(NULL);

        strftime(t, 30 , "%X %D",localtime(&seconds));//The form of date

        serial.printf("Time = %s\n" ,t);// The form of date displaying on the screen
        lcd.printString(t,0,5);//The coordinate of date
        wait(1.0);
        if(setTimerFlag) // if updated time has been sent
        {
            setTimerFlag = 0;// clear flag
            setTime(); // update time

        }


        measurement = bmp180.readValues();// The values received by BMP180
        char buffer[14];//array for buffer
        int length = sprintf(buffer,"T= %.2f C",measurement.temperature);//Thr form of values of temperature
        if(length<=14)//If less than 14 words a line
            lcd.printString(buffer,0,1); // The coordinate of date
        char buffer2[14];//14 words a line
        length =sprintf(buffer2,"P = %.2f mb",measurement.pressure);//The form of values of pressure
        if(length<=14)//If less than 14 words a line
            lcd.printString(buffer2,0,2); //The coordinate of values
        wait(1.0);//wait 1 sec
    }



}

/**
add up one integer variable
@setTime - print it for debugging
@timeflag - read rx string into buffer
@param time - integer to add
@atoi - update the time
*/

void setTime()// print time for debugging
{
    serial.printf("set_time - %s",rxString);// atoi() converts a string to an integer

    int time = atoi(rxString);// update the time

    set_time(time);
}

void serialISR()
{
    // when a serial interrupt occurs, read rx string into buffer
    serial.gets(rxString,16);
    // set flag
    setTimerFlag = 1;
}








