// Latch Inc.
// Antonio F Mondragon
// 20160714
// for the Adafruit 9DOF Modulke and the Sparkfun microSD card shield

#include "mbed.h"
#include "LSM303DLHC.h"
#include "L3GD20.h"
#include "SDFileSystem.h"
#include "nrf51_rtc.h"

#define M_PI 3.14158

// Create objects
Serial debug(USBTX,USBRX);
// For Nordic
LSM303DLHC compass(p7, p30);
L3GD20 gyro(p7, p30);

// Create the SD filesystem
SDFileSystem sd(p25, p28, p29, p20, "sd"); // MOSI, MISO, SCLK, SSEL

// Create a ticker to use the nRF51 RTC
Ticker flipper;

// Assign interrupts to switches
InterruptIn btn1(p17); // Start sampling
InterruptIn btn2(p18); // Stop sampoling

// LED definitions
DigitalOut led1(LED1);
DigitalOut led2(LED2);

// Global variables
int start = 0;
int stop = 0;


// Generated when button 1 is pressed on rising edge START
void start_smpl()
{
    start = 1;
    stop = 0;
}

// Generated when button 1 is pressed on rising edge STOP
void stop_smpl()
{
    stop = 1;
    start = 0;
}

// Fillped every second
void flip()
{
    led2 = !led2;
}

int main()
{
    int acc[3];
    int mag[3];
    float g[3];
    led1= 1;
    char filename[256];
    char secs_str[256];

    struct tm t;
    time_t seconds;

    FILE *fp;
    
    // Attach functions to interrupts
    btn1.rise(&start_smpl);
    btn2.rise(&stop_smpl);
    flipper.attach(&flip, 1.0); // the address of the function to be attached (flip) and the interval (2 seconds)
    
    // Enable serial port
    debug.format(8,Serial::None,1);
    debug.baud(115200);
    debug.printf("LSM303DLH Test\x0d\x0a");
    
    // Initialize compass
    compass.init();
    compass.setOffset(0.00,0.00,0.00); // example calibration
    compass.setScale(1.00,1.00,1.00);    // example calibration

//    // Initialize current time if needed  
//    printf("Enter current date and time:\n");
//    printf("YYYY MM DD HH MM SS[enter]\n");
//    scanf("%d %d %d %d %d %d", &t.tm_year, &t.tm_mon, &t.tm_mday
//          , &t.tm_hour, &t.tm_min, &t.tm_sec);

    // adjust for tm structure required values
    t.tm_year = t.tm_year - 1900;
    t.tm_mon = t.tm_mon - 1;

    // set the time
    rtc.set_time(mktime(&t));

    while(1) {
        debug.printf("Press Button 1 to Start sampling\n\r");
        debug.printf("Press Button 2 to Stop sampling\n\r");
        // Check for button 1 pressed
        while(!start) {
            led1 = 1;
        }
        // Start sampling
        led1 = 0;
        debug.printf("Started sampling\n\r");
        // Get the time and create a file with the number of seconds in hex appended
        seconds = rtc.time(); 
        sprintf(secs_str, "%s", ctime(&seconds));
        printf("Started at: %s\n\r", secs_str );
        sprintf(filename, "/sd/latch9DOF_%08x",seconds);
        fp = fopen(filename, "w");
        // Verify that file can be created
        if ( fp == NULL ) {
            debug.printf("Cannot create file %s\n\r", filename);
            wait(0.5);
            while(1) {
                led1 = !led1;
                wait(0.5);
            }
        } else
            debug.printf("File %s created successfully\n\r", filename);
        
        // Sample until button 2 is pressed    
        while(!stop) {
            led1 = 0;
            compass.read(acc,mag);
            gyro.read(&g[0],&g[1],&g[2]);
            debug.printf("%6d,\t%6d,\t%6d,\t%6d,\t%6d,\t%6d,\t%6.2f,\t%6.2f,\t%6.2f\n\r",acc[0],acc[1],acc[2],mag[0],mag[1],mag[2],g[0],g[1],g[2]);
            fprintf(fp,  "%6d,\t%6d,\t%6d,\t%6d,\t%6d,\t%6d,\t%6.2f,\t%6.2f,\t%6.2f\n\r",acc[0],acc[1],acc[2],mag[0],mag[1],mag[2],g[0],g[1],g[2]);
            wait(0.1);
        }
        // Stop Sampling and close file
        led1 = 1;
        debug.printf("Stopped sampling\n\r");
        debug.printf("Results stored in %s\n\r", filename);
        fclose(fp);
     }
}
