
/* Includes ------------------------------------------------------------------*/

/* mbed specific header files. */
#include "mbed.h"

/* Helper header files. */
#include "DevSPI.h"

/* Component specific header files. */
#include "L6474.h"


/* Variables -----------------------------------------------------------------*/

/* Initialization parameters. */
L6474_init_t init = {
    160,                              /* Acceleration rate in pps^2. Range: (0..+inf). */
    160,                              /* Deceleration rate in pps^2. Range: (0..+inf). */
    1600,                             /* Maximum speed in pps. Range: (30..10000]. */
    800,                              /* Minimum speed in pps. Range: [30..10000). */
    250,                              /* Torque regulation current in mA. Range: 31.25mA to 4000mA. */
    L6474_OCD_TH_750mA,               /* Overcurrent threshold (OCD_TH register). */
    L6474_CONFIG_OC_SD_ENABLE,        /* Overcurrent shutwdown (OC_SD field of CONFIG register). */
    L6474_CONFIG_EN_TQREG_TVAL_USED,  /* Torque regulation method (EN_TQREG field of CONFIG register). */
    L6474_STEP_SEL_1_16,              /* Step selection (STEP_SEL field of STEP_MODE register). */
    L6474_SYNC_SEL_1_2,               /* Sync selection (SYNC_SEL field of STEP_MODE register). */
    L6474_FAST_STEP_12us,             /* Fall time value (T_FAST field of T_FAST register). Range: 2us to 32us. */
    L6474_TOFF_FAST_8us,              /* Maximum fast decay time (T_OFF field of T_FAST register). Range: 2us to 32us. */
    3,                                /* Minimum ON time in us (TON_MIN register). Range: 0.5us to 64us. */
    21,                               /* Minimum OFF time in us (TOFF_MIN register). Range: 0.5us to 64us. */
    L6474_CONFIG_TOFF_044us,          /* Target Swicthing Period (field TOFF of CONFIG register). */
    L6474_CONFIG_SR_320V_us,          /* Slew rate (POW_SR field of CONFIG register). */
    L6474_CONFIG_INT_16MHZ,           /* Clock setting (OSC_CLK_SEL field of CONFIG register). */
    L6474_ALARM_EN_OVERCURRENT |
    L6474_ALARM_EN_THERMAL_SHUTDOWN |
    L6474_ALARM_EN_THERMAL_WARNING |
    L6474_ALARM_EN_UNDERVOLTAGE |
    L6474_ALARM_EN_SW_TURN_ON |
    L6474_ALARM_EN_WRONG_NPERF_CMD    /* Alarm (ALARM_EN register). */
};

/* Motor Control Component. */
L6474 *motor;


/* Functions -----------------------------------------------------------------*/

/**
  * @brief  This is an example of user handler for the flag interrupt.
  *         Empty parts can be implemented by the user upon needs.
  * @param  None.
  * @retval None.
  * @note   If needed, implement it, and then attach and enable it:
  *           + motor->AttachFlagIRQ(&FlagIRQHandler);
  *           + motor->EnableFlagIRQ();
  *         To disable it:
  *           + motor->DisbleFlagIRQ();
  */
void FlagIRQHandler(void)
{
    /* Set ISR flag. */
    motor->isr_flag = TRUE;

    /* Get the value of the status register. */
    unsigned int status = motor->get_status();
    
    /* Check HIZ flag: if set, power brigdes are disabled. */
    if ((status & L6474_STATUS_HIZ) == L6474_STATUS_HIZ)
    { /* HIZ state. Action to be customized. */ }
    
    /* Check direction. */
    if ((status & L6474_STATUS_DIR) == L6474_STATUS_DIR)
    { /* Forward direction is set. Action to be customized. */ }
    else
    { /* Backward direction is set. Action to be customized. */ }
    
    /* Check NOTPERF_CMD flag: if set, the command received by SPI can't be performed. */
    /* This often occures when a command is sent to the L6474 while it is not in HiZ state. */
    if ((status & L6474_STATUS_NOTPERF_CMD) == L6474_STATUS_NOTPERF_CMD)
    { /* Command received by SPI can't be performed. Action to be customized. */ }
     
    /* Check WRONG_CMD flag: if set, the command does not exist. */
    if ((status & L6474_STATUS_WRONG_CMD) == L6474_STATUS_WRONG_CMD)
    { /* The command received by SPI does not exist. Action to be customized. */ }
    
    /* Check UVLO flag: if not set, there is an undervoltage lock-out. */
    if ((status & L6474_STATUS_UVLO) == 0)
    { /* Undervoltage lock-out. Action to be customized. */ }
    
    /* Check TH_WRN flag: if not set, the thermal warning threshold is reached. */
    if ((status & L6474_STATUS_TH_WRN) == 0)
    { /* Thermal warning threshold is reached. Action to be customized. */ }
    
    /* Check TH_SHD flag: if not set, the thermal shut down threshold is reached. */
    if ((status & L6474_STATUS_TH_SD) == 0)
    { /* Thermal shut down threshold is reached. Action to be customized. */ }
    
    /* Check OCD  flag: if not set, there is an overcurrent detection. */
    if ((status & L6474_STATUS_OCD) == 0)
    { /* Overcurrent detection. Action to be customized. */ }

    /* Reset ISR flag. */
    motor->isr_flag = FALSE;
}

/**
  * @brief  This is an example of user handler for the errors.
  * @param  error error-code.
  * @retval None
  * @note   If needed, implement it, and then attach it:
  *           + motor->AttachErrorHandler(&ErrorHandler);
  */
void ErrorHandler(uint16_t error)
{
    /* Printing to the console. */
    printf("Error: %d.\r\n", error);
    
    /* Aborting the program. */
    exit(EXIT_FAILURE);
}


/* Main ----------------------------------------------------------------------*/

int main()
{
    /*----- Initialization. -----*/

    /* Initializing SPI bus. */
    DevSPI dev_spi(D11, D12, D13);

    /* Initializing Motor Control Component. */
    motor = new L6474(D2, D8, D7, D9, D10, dev_spi);
    if (motor->init(&init) != COMPONENT_OK) {
        exit(EXIT_FAILURE);
    }

    /* Attaching and enabling the user handler for the flag interrupt. */
    motor->attach_flag_irq(&FlagIRQHandler);
    motor->enable_flag_irq();

    /* Printing to the console. */
    printf("Stepper Motor Control with Joystick Example\r\n\n");

int speed;
////////////////////////////////////////////////////////////////////////////////
int a,b,c,d,e,f,k;
int i;
int x,y;
float u,w; 

//DigitalIn botao_A(D2);
DigitalIn botao_B(D3);
DigitalIn botao_C(D4);
DigitalIn botao_D(D5);
DigitalIn botao_E(D6);
//DigitalIn botao_F(D7);
//DigitalIn botao_K(D8);

AnalogIn eixo_X(A0);
AnalogIn eixo_Y(A1);

DigitalOut myled(LED1);
 
Serial pc(USBTX, USBRX);
 
pc.baud(9600);

a=b=c=d=e=f=k=0; //a=0,b=0,c=0,d=0,e=0,f=0,k=0;
////////////////////////////////////////////////////////////////////////////////

    /*----- Changing step mode to full step mode. -----*/

    /* Printing to the console. */
    printf("--> Changing step mode to full step mode.\r\n");

    /* Selecting full step mode. */
    if (!motor->set_step_mode((StepperMotor::step_mode_t) STEP_MODE_FULL)) {
        printf("    Step Mode not allowed.\r\n");
    }

    /* Setting speed and acceleration to be consistent with full step mode. */
    motor->set_max_speed(1000);
    motor->set_min_speed(50);
    motor->set_acceleration(10);
    motor->set_deceleration(10);
    
}
/////////////////////////////////////////////////////////////////////////////////////

------------------------------------------------------------------------------*/
   

//cls();
pc.printf("\f\n\r\t\t\t\t\t\tHello Analog World!!!");
pc.printf("\n\rStart\tA=%d,\tB=%d,\tC=%d,\tD=%d,\tE=%d,\tF=%d,\tK=%d,\tEixos<int>\tEixos<float>\tEixos<status>",a,b,c,d,e,f,k);
pc.printf("\n\rBotao\tA\tB\tC\tD\tE\tF\tK\tx\ty\tX\tY\n");

 
  while(1) {
    
    if (botao_A == 0) { // Botão usuário pressionado
      a++; 
    }
    if (botao_B == 0) { // Botão externo pressionado
      b++; 
    }
    if (botao_C == 0) { // Botão usuário pressionado
      c++; 
    }
    if (botao_D == 0) { // Botão usuário pressionado
      d++; 
    }
    if (botao_E == 0) { // Botão usuário pressionado
      e++; 
    }
    if (botao_F == 0) { // Botão usuário pressionado
      f++; 
    }
    if (botao_K == 0) { // Botão usuário pressionado
      k++; 
    }
//x=(int)eixo_X.read();
u=eixo_X.read();
//x=(int)u;
x=eixo_X.read()*255;    //Converte uma leitura do ADC em float para formato int e armazena na variável y.

//w=eixo_Y.read();

//y=eixo_Y.read()*255;    //Converte uma leitura do ADC em float para formato int e armazena na variável y.

pc.printf("\rValor\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%X \t%X \t%2.3f\t%2.3f",a,b,c,d,e,f,k,x,y,eixo_X.read(),eixo_Y.read());

                                                    //Detecta a faixa em que o cursor do pot se encontra:
if (u>0.505){pc.printf(" X FWD ");
            /* Setting the speed. */
            motor->set_max_speed(x);
            /* Requesting to run Forward. */
            motor->run(StepperMotor::FWD);}                 //pot > 0.505V (comanda acionamento X proporcional para FRENTE);
else{if (u<0.495)
    {pc.printf(" X BWD ");
    /* Setting the speed. */
    motor->set_max_speed(x);
    /* Requesting to run Backward. */
    motor->run(StepperMotor::BWD);}     //pot < 0.495V (comanda acionamento X proporcional para TRAS);
    else{pc.printf(" X STOP");                  //0.495V < pot < 0.505V (comanda acionamento X para permanecer PARADO).
        /* Requesting to immediatly stop. */
        motor->hard_stop();}
     };

      wait(0.2);
 }
}
         