//***********************************
//Blend of Ethernet Code with OneWire
//***********************************

#include "mbed.h"
#include "EthernetInterface.h"
#include "mbed_rpc.h"
#include "RPCCommand.h"
#include "HTTPServer.h"
#include "Formatter.h"
#include "RequestHandler.h"
#include "RPCType.h"

#define SERVER_PORT 80

#include <mbed.h>
#include "DS18S20.h"
#include "DS18B20.h"
#include "OneWireDefs.h"
//***new adding
#include "DebugTrace.h"

//#define THERMOMETER DS18S20
#define THERMOMETER DS18B20

//***new adding
DigitalOut relay(p21);
//***new adding
float realTemp = -999;
//***new adding
DebugTrace pc_ds18B20B(ON, TO_SERIAL);

HTTPServer create_simple_server()
{    
    HTTPServer srv;
    srv.add_request_handler("DELETE", new DeleteRequestHandler());
    srv.add_request_handler("GET", new GetRequestHandler());
    srv.add_request_handler("PUT", new PutRequestHandler());
    return srv;
}

HTTPServer create_interactive_server()
{
    HTTPServer srv(new InteractiveHTMLFormatter());
    srv.add_request_handler("GET", new ComplexRequestHandler());
    return srv;
}

int main(void)
{
    // device( crcOn, useAddress, parasitic, mbed pin )
    THERMOMETER device(true, true, false, p25);
    
    while (!device.initialize());    // keep calling until it works
    
    while (true)
    {
        RPCType::instance().register_types();
        device.setResolution(twelveBit);
        realTemp=device.readTemperature();
        
        if (realTemp<24)
        {
            relay=1;
            pc_ds18B20B.traceOut("Less than 24");
            EthernetInterface eth;
            if(eth.init())
            {
                printf("Error while initializing the ethernet interface.\n");
                return -1;
            }
            if(eth.connect())
            {
                printf("Error while starting the ethernet interface.\n");
                return -1;
            }
            
            printf("IP Address is %s\n", eth.getIPAddress());
            
            HTTPServer srv = create_interactive_server();
        
            if(!srv.init(SERVER_PORT))
            {
                eth.disconnect();
                return -1;
            }
        
            srv.run();
        }
        if (realTemp>=24)
        {
            relay=0;
            pc_ds18B20B.traceOut("More than 24");
            EthernetInterface eth;
            if(eth.init())
            {
                printf("Error while initializing the ethernet interface.\n");
                return -1;
            }
            if(eth.connect())
            {
                printf("Error while starting the ethernet interface.\n");
                return -1;
            }
            
            printf("IP Address is %s\n", eth.getIPAddress());
            
            HTTPServer srv = create_interactive_server();
        
            if(!srv.init(SERVER_PORT))
            {
                eth.disconnect();
                return -1;
            }
        
            srv.run();
        }
        wait(5);
    }
     
    return EXIT_SUCCESS;
}


