/* MCP4812 library 
 * MCP4822 library
 * Copyright (c) 2008-2010, Lerche
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * modified on 27.05.2012 for MCP4812 dual SPI DAC with 10 bits resolution 
 */

#include "mbed.h"
#include "MCP4812.h"

using namespace mbed;

MCP4812::MCP4812(PinName mosi, PinName sclk, PinName ncs) : _spi(mosi, NC, sclk), _ncs(ncs) {
    _init();
}

void MCP4812::_init() {
    _spi.format(16, 0);  // Setup the SPI
    return;
}

void MCP4812::writeA(int ValueA, int gainA) {
    ValueA = ValueA << 2;
    ValueA = ValueA &= 0x0FFF;
    if (gainA == 1) {
        ValueA = ValueA |= 0x2000; // gain 1x, 0V...2.048V (2mV step)
        }
    if (gainA == 2) {
        ValueA = ValueA |= 0x0000; // gain 2x, 0V...4.096V (4mV step)
        }
    ValueA = ValueA |= 0x1000;      // Write to A register  
    _ncs = 0;       // Chipselect the device.
    _spi.write(ValueA);
    _ncs = 1;
    return;
}

void MCP4812::writeB(int ValueB, int gainB) {
    ValueB = ValueB << 2;
    ValueB = ValueB &= 0x0FFF;
    if (gainB == 1) {
        ValueB = ValueB |= 0x2000; // gain 1x, 0V...2.048V (2mV step)
        }
    if (gainB == 2) {
        ValueB = ValueB |= 0x0000; // gain 2x, 0V...4.096V (4mV step)
        }
    ValueB = ValueB |= 0x9000;      // Write to B register
    _ncs = 0;       // Chipselect the device.
    _spi.write(ValueB);
    _ncs = 1;
    return;
}

void MCP4812::write(char chan, int value, int gain) {
    value = value << 2;
    value = value &= 0x0FFF;
    if (gain == 1) {
        value = value |= 0x2000; // gain 1x, 0V...2.048V (2mV step)
        }
    if (gain == 2) {
        value = value |= 0x0000; // gain 2x, 0V...4.096V (4mV step)
        }
    switch(chan){
        case('A'):
            value = value |= 0x1000;
            break; 
        case('B'):
            value = value |= 0x9000;
            break;
        case('a'):
            value = value |= 0x1000;
            break; 
        case('b'):
            value = value |= 0x9000;
            break;
        case(0x01):
            value = value |= 0x1000;
            break; 
        case(0x02):
            value = value |= 0x9000;
            break;
        default: 
            break;        
    }
    _ncs = 0;
    _spi.write(value);
    _ncs = 1;
    return;
}

void MCP4812::shdn() {
    _ncs = 0;
    _spi.write(0x0000);
    _ncs = 1;
    return;
}