/* MCP4812 library
 * MCP4822 library 
 * Copyright (c) 2008-2010, Lerche
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * modified on 27.05.2012 for MCP4812 dual SPI DAC with 10 bits resolution
 */

#include "mbed.h"

#ifndef MCP4812_H
#define MCP4812_H

/** Interface to a 10-bit SPI dual-output DAC */
class MCP4812 {
public:
     /** Constructor: MCP4812
      * 
      * @param MOSI - The SPI Data out pin  
      * @param SCLK - The SPI clock pin
      * @param /CS - The ChipSelect pin 
      */ 
    MCP4812 (PinName mosi, PinName sclk, PinName ncs);
     /** Write to the A-output, max 1023 (0x3FF) with 2/4 mV steps
      *  
      * @param ValueA The value to be written
      */ 
    void writeA (int ValueA, int gainA);
     /** Write to the B-output, max 1023 (0x3FF) with 2/4 mV steps
      *
      * @param ValueB The valkue to be written
      */ 
    void writeB (int ValueB, int gainB);
     /** Write to any output, accoding to letter.
      *
      *
      */
    void write(char chan, int value, int gain);
     /** Shutdown the output on specific channel
      *
      *
      */
    void shdn();
    
    private :    
        SPI _spi;
        DigitalOut _ncs;
        void _init();
  };

#endif