#include "mbed.h"
 
SPI device( PB_15, PB_14, PB_13);
Serial pc(USBTX, USBRX);

DigitalOut sdc( PC_9 );
DigitalOut cs( PC_4 );
DigitalOut shutdown( PB_8 );
DigitalOut resb( PB_9 );
DigitalOut LED__( PA_5 );
DigitalOut vddi( PB_12 );
DigitalOut vddsys( PA_11 );
DigitalOut clockgate( PA_12 );

void spiWrite( uint8_t data );
void writeOut( uint8_t command, uint8_t data0, uint8_t data1 );
uint8_t ascii2hex( uint8_t input );
void initPanel( void );
uint8_t shutpin( uint8_t input );
uint8_t resetpin( uint8_t input );
void repChar( uint8_t input, uint8_t reps, uint16_t delay_ms );
void spinit(void);

    uint8_t shutstate;

#define invShut 0
#define invReset 0
int main()
{
    uint8_t rec_c[20];
    uint8_t pos = 0;
    uint8_t hexbytes[3];
    uint8_t temp = 0;
    uint8_t error = 0;

    uint8_t loop = 0;
    
    pc.baud( 115200 );
    device.format( 8, 3 );
    device.frequency ( 2000000 );
    //int i = 0;
    //init write states
    sdc = 1;
    shutdown = shutstate = 0;
    cs = 1;
    pc.printf("Panel Initializor 0.1 - Waveform Control\n");
    
    while ( 1 )
    {
        rec_c[ pos ] = pc.getc();
        if ( rec_c[ pos ] != '\n' )
        {
            pc.putc( rec_c[ pos ] );
            pos++;
        }
        else
        {
            switch ( rec_c[ 0 ] )
            {
                case 's':
                {
                    if      ( rec_c[ 1 ] == '1' ) { shutdown = shutstate = 1;   pc.printf("Shutdown %d\n", shutstate); }
                    else if ( rec_c[ 1 ] == '0' ) { shutdown =  shutstate = 0;   pc.printf("Shutdown %d\n", shutstate); }
                    else if ( rec_c[ 1 ] == 't' )
                    {
                        if ( shutstate == 1 )   { shutstate = 0; }
                        else                    { shutstate = 1; }
                        shutdown = shutstate;
                        wait_us( 100 );
                        if ( shutstate == 1 )   { shutstate = 0; }
                        else                    { shutstate = 1; }
                        shutdown = shutstate;
                        if ( shutstate == 1 )   { pc.printf("high-low-high\n" ); }
                        else                    { pc.printf("low-high-low\n" ); }
                    }
                    //else if ( rec_c[ 1 ] == 'l' ) { shutdown = 1; wait_us(50); shutdown = 0; wait_us(50); shutdown = 1; }
                    else                          { pc.printf("invalid command\n"); }
                    break;
                }
                case 'r':
                {
                    if      ( rec_c[ 1 ] == '1' ) { resb = 1;   pc.printf("Reset High\n"); }
                    else if ( rec_c[ 1 ] == '0' ) { resb = 0;   pc.printf("Reset Low\n"); }
                    else                          { pc.printf("invalid command\n"); }
                    break;
                }
                case 'i':
                {
                    if      ( ( rec_c[ 1 ] == 'n' ) && ( rec_c[ 2 ] == 'i' ) && ( rec_c[ 3 ] == 't' ) )
                    {
                        pc.printf("Sending init sequence\n");
                        initPanel();
                    }
                    else if ( rec_c[ 1 ] == 'r' )
                    {
                        pc.printf("resetting pins to off state\n");
                        clockgate = 0;
                        vddi = 1;
                        vddsys = 1;
                        pc.printf("Shutdown %d, Reset %d, Clock Gate %d, VDDI %d, VDDSys %d\n", shutpin( 0 ), resetpin( 0 ), clockgate.read(), vddi.read(), vddsys.read() );
                        
                    }
                    else if ( rec_c[ 1 ] == 's' )
                    {
                        pc.printf(" Power Up Sequence\n" );
                        /// set initial conditions
                        clockgate = 0;
                        vddi = 1;
                        vddsys = 1;
                        pc.printf("Shutdown %d, Reset %d, Clock Gate %d, VDDI %d, VDDSys %d\n", shutpin( 0 ), resetpin( 0 ), clockgate.read(), vddi.read(), vddsys.read() );
                        pc.printf("Begin Sequence");
                        repChar( '.' , 3, 125 );
                        
                        vddi = 0;
                        pc.printf("\n VDDI UP\n");
                        
                        wait_ms(1);
                        vddsys = 0;
                        pc.printf("wait 1ms, VDD Sys UP\n");
                        
                        wait_ms(1);
                        resetpin(1);
                        pc.printf("wait 1ms, Reset High\n");
                        
                        pc.printf("SPI DATA... Not Sent\n");
                        
                        wait_ms(1);
                        clockgate = 1;
                        pc.printf("wait 1ms, Dotlock Enabled\n");
                        
                        wait_ms(1);
                        shutpin(1);
                        pc.printf("wait 1ms, Shutdown High\n");
                        pc.printf("Commence normal operation");
                    
                        
                        
                        
                    }
                    break;
                }
                case 'v':
                {
                    if      ( rec_c[ 1 ] == 'd' )
                    {
                        if      ( rec_c[ 2 ] == '1' )       { vddi = 0; }
                        else if ( rec_c[ 2 ] == '0' )       { vddi = 1; }
                        else                                { pc.printf("bad input\n"); }
                    }
                    else if ( rec_c[ 1 ] == 's' )
                    {
                        if      ( rec_c[ 2 ] == '1' )       { vddsys = 0; }
                        else if ( rec_c[ 2 ] == '0' )       { vddsys = 1; }
                        else                                { pc.printf("bad input\n"); }
                    }
                    break;
                }
                            /// 0123456789ab
                case 'x':   /// x16 00 00 00
                {
                    if      ( ( rec_c[ 1 ] == '1' ) && ( rec_c[ 2 ] == '6' ) && ( rec_c[ 3 ] == ' ' ) &&  ( rec_c[ 6 ] == ' ' ) && ( rec_c[ 9 ] == ' ' ) )
                    {
                        error = 0;
                        hexbytes[0] = ascii2hex( rec_c[ 4 ] );
                        if      ( hexbytes[0] == 255 )  { pc.printf( "bad input\n");    error = 1; }
                        else    { hexbytes[0] *= 16; }  // weight for first digit
                        
                        temp = ascii2hex( rec_c[ 5 ] );
                        if      ( temp == 255 )         { pc.printf( "bad input\n");    error = 1; }
                        else    { hexbytes[0] += temp; }
                        
                        hexbytes[1] = ascii2hex( rec_c[ 7 ] );
                        if      ( hexbytes[1] == 255 )  { pc.printf( "bad input\n");    error = 1; }
                        else    { hexbytes[1] *= 16; }  // weight for first digit
                        
                        temp = ascii2hex( rec_c[ 8 ] );
                        if      ( temp == 255 )         { pc.printf( "bad input\n");    error = 1; }
                        else    { hexbytes[1] += temp; }
                        
                        hexbytes[2] = ascii2hex( rec_c[ 10 ] );
                        if      ( hexbytes[2] == 255 )  { pc.printf( "bad input\n");    error = 1; }
                        else    { hexbytes[2] *= 16; }  // weight for first digit
                        
                        temp = ascii2hex( rec_c[ 11 ] );
                        if      ( temp == 255 )         { pc.printf( "bad input\n");    error = 1; }
                        else    { hexbytes[2] += temp; }
                        
                        if ( error != 1 )
                        {
                            pc.printf( "Sending 0x"); pc.putc( rec_c[ 7 ] ); pc.putc( rec_c[ 8 ] ); pc.putc( rec_c[ 10 ] ); pc.putc( rec_c[ 11 ] ); pc.printf(" to address: 0x"); pc.putc( rec_c[ 4 ] ); pc.putc( rec_c[ 5 ] );
                            pc.printf( "\n\n" );
                            writeOut( hexbytes[0], hexbytes[1], hexbytes[2] );
                        }
                        else
                        {
                            pc.printf("bad input\n\n");
                        }
                    }
                    break;
                }
                case '?':
                {
                    pc.printf("Commands:\n");
                    pc.printf("i - init\n");
                    pc.printf("s1/s0 - shutdown line level\n");
                    pc.printf("x16 XX xx xx - write xx xx to XX register\n\n");

                    break;
                }
                default:
                {
                    break;
                } 
            }///EndSwitch
            pos = 0;
        }///Endif - return checker
    }///EndWhile
}


void writeOut( uint8_t command, uint8_t data0, uint8_t data1 )
{
    
   // uint8_t data8[2] = { (uint8_t)(data >> 8) , (uint8_t)(data & 0xFF) };
    sdc = 0;
    wait_us(1);
    spiWrite( command );
    sdc = 1;
    wait_us(1);
    spiWrite( data0 );
    spiWrite( data1 );
}

void spiWrite( uint8_t data )
{
    cs = 0;
    wait_us(1);
    device.write( data );
    wait_us(1);
    cs = 1;
    asm("nop");
    asm("nop");
    asm("nop");
    //wait_ms(1);
}
    
uint8_t ascii2hex( uint8_t input )
{
    uint8_t retval = 0;
    if      ( ( input > 47 ) && ( input < 58  ) ) { retval = input +  0; }  /// 0-9
    else if ( ( input > 64 ) && ( input < 71  ) ) { retval = input + 10; }  /// A-F
    else if ( ( input > 96 ) && ( input < 103 ) ) { retval = input + 10; }  /// a-f
    else    { retval = 255; }                                                /// other - error indicator
    return retval;
}
uint8_t shutpin( uint8_t input )
{
    shutdown = shutstate = input;
    return shutstate;
}
uint8_t resetpin( uint8_t input )
{
    resb = input;
    return input;
}

void repChar( uint8_t input, uint8_t reps, uint16_t delay_ms )
{
    uint8_t i = 0;
    for ( i = 0 ; i < reps ; i++ )
    {
        wait_ms( delay_ms );
        pc.putc((char)input);
    }
}
void initPanel( void )
{
        /// Power Up Sequence 19.2
    shutdown = 1;
    resb = 1;
    wait_us( 100 );
    resb = 0;
    wait_us( 100 );
    resb = 1;
    ///wait > 1us
    wait_us( 2 );
    shutdown = 0;           ///0 = shutdown true
    ///wait 1ns (commands aren't that fast anyways)
    
    ///Init SPI
    LED__ = 0;      ///IGNORE ME
        
    //routine
    wait_us( 50 );
    //shutdown = 1;
    //wait_ms(1);
    writeOut( 0x28, 0x00, 0x06 );
    writeOut( 0x02, 0x02, 0x34 );
    //wait_ms(1);
    writeOut( 0x01, 0x43, 0x0F );
    
    
    
    writeOut( 0x2B, 0x85, 0x03 );
    //wait_ms(1);
    writeOut( 0x0F, 0x00, 0x00 );
    //wait_ms(1);
    writeOut( 0x03, 0x41, 0x44 );
    //wait_ms(1);
    writeOut( 0x05, 0x05, 0x57 );
    //wait_ms(1);
    writeOut( 0x0c, 0x11, 0x9C );
    //wait_ms(1);
    
    writeOut( 0x0D, 0x06, 0x0B );
    //wait_ms(1);
    writeOut( 0x0B, 0x8C, 0x05 );
    //wait_ms(1);
    writeOut( 0x15, 0x00, 0xD2 );           //NON_INVERTED SHUTDOWN (0xD2)
    //wait_ms(1);
    writeOut( 0x16, 0xEF, 0xA6 );
    //wait_ms(1);
    writeOut( 0x17, 0x00, 0x01 );
    //wait_ms(1);
    
    writeOut( 0x30, 0xA0, 0xA0 );
    //wait_ms(1);
    writeOut( 0x31, 0x7D, 0xD5 );
    //wait_ms(1);
    writeOut( 0x32, 0x12, 0x05 );
    //wait_ms(1);
    writeOut( 0x33, 0x41, 0x88 );
    //wait_ms(1);
    writeOut( 0x34, 0x65, 0xA5 );
    //wait_ms(1);
    writeOut( 0x35, 0x8C, 0xC6 );
    //wait_ms(1);
    writeOut( 0x36, 0x11, 0x85 );
    
    writeOut( 0x37, 0x28, 0x72 );
    
    writeOut( 0x1E, 0x02, 0xAA );
    
    writeOut( 0x28, 0x00, 0x06 );           //Enable Extended Command
    
    writeOut( 0x05, 0x05, 0x57 );           //Read IDB
    
    writeOut( 0x2E, 0xB2, 0x14 );           /// set SDO to: Module ID or VCOMDC
    
    writeOut( 0x2B, 0x85, 0x03 );           //Enable Enable SDO
                                            //POR value 0x0503 -> bit 15 is SDO enable so, 0x8503

    

    
    writeOut( 0x00, 0x00, 0x00 );                        
    
    writeOut( 0x00, 0x00, 0x00 );  
    wait_us( 20);
    
    writeOut( 0x04, 0x44, 0x00 );
    
    LED__ =1;
    wait_ms(500);
    LED__=0;
    
    
    
    wait_ms( 1 );
     wait_ms(5000);
    //shutdown = (invShut) ? 0 : 1;
    shutdown = 1;
    writeOut( 0x2D, 0x3F, 0x00 );  
    wait_ms(2000);
//    if ( invShut == 1 )
//    {
//        shutdown = 0;
//    }
//    {
//        shutdown = 1;
//    }
    LED__ = 1;
}
void spinit(void)
{
        writeOut( 0x28, 0x00, 0x06 );
    writeOut( 0x02, 0x02, 0x34 );
    //wait_ms(1);
    writeOut( 0x01, 0x43, 0x0F );
    
    
    
    writeOut( 0x2B, 0x85, 0x03 );
    //wait_ms(1);
    writeOut( 0x0F, 0x00, 0x00 );
    //wait_ms(1);
    writeOut( 0x03, 0x41, 0x44 );
    //wait_ms(1);
    writeOut( 0x05, 0x05, 0x57 );
    //wait_ms(1);
    writeOut( 0x0c, 0x11, 0x9C );
    //wait_ms(1);
    
    writeOut( 0x0D, 0x06, 0x0B );
    //wait_ms(1);
    writeOut( 0x0B, 0x8C, 0x05 );
    //wait_ms(1);
    writeOut( 0x15, 0x00, 0xD2 );           //NON_INVERTED SHUTDOWN (0xD2)
    //wait_ms(1);
    writeOut( 0x16, 0xEF, 0xA6 );
    //wait_ms(1);
    writeOut( 0x17, 0x00, 0x01 );
    //wait_ms(1);
    
    writeOut( 0x30, 0xA0, 0xA0 );
    //wait_ms(1);
    writeOut( 0x31, 0x7D, 0xD5 );
    //wait_ms(1);
    writeOut( 0x32, 0x12, 0x05 );
    //wait_ms(1);
    writeOut( 0x33, 0x41, 0x88 );
    //wait_ms(1);
    writeOut( 0x34, 0x65, 0xA5 );
    //wait_ms(1);
    writeOut( 0x35, 0x8C, 0xC6 );
    //wait_ms(1);
    writeOut( 0x36, 0x11, 0x85 );
    
    writeOut( 0x37, 0x28, 0x72 );
    
    writeOut( 0x1E, 0x02, 0xAA );
    
    writeOut( 0x28, 0x00, 0x06 );           //Enable Extended Command
    
    writeOut( 0x05, 0x05, 0x57 );           //Read IDB
    
    writeOut( 0x2E, 0xB2, 0x14 );           /// set SDO to: Module ID or VCOMDC
    
    writeOut( 0x2B, 0x85, 0x03 );           //Enable Enable SDO
                                            //POR value 0x0503 -> bit 15 is SDO enable so, 0x8503

    

    
    writeOut( 0x00, 0x00, 0x00 );                        
    
    writeOut( 0x00, 0x00, 0x00 );  
    wait_us( 20);
    
    writeOut( 0x04, 0x44, 0x00 );
}