#include    "mbed.h"

//motor spec
#define     STEP_SIZE   1.8
#define     MAX_SPEED   50

//algo
#define     SPEED_STEP  5

DigitalOut motor_a1(p30);
DigitalOut motor_a2(p29);
DigitalOut motor_b1(p28);
DigitalOut motor_b2(p27);
InterruptIn bp_up(p22);
InterruptIn bp_dw(p21);

float   speed = SPEED_STEP;

void    SpeedUp() {
    if (speed < MAX_SPEED)
        speed += SPEED_STEP;
}

void    SpeedDw() {
    if (speed > (-1 * MAX_SPEED))
        speed -= SPEED_STEP;
}

int main() {
    unsigned char   pos = 0;
    unsigned char   cycle[8][4] = {
        {1, 0, 0, 0},
        {1, 0, 1, 0},
        {0, 0, 1, 0},
        {0, 1, 1, 0},
        {0, 1, 0, 0},
        {0, 1, 0, 1},
        {0, 0, 0, 1},
        {1, 0, 0, 1}
    };

    bp_up.rise(&SpeedUp);
    bp_dw.rise(&SpeedDw);

    while (1) {
        motor_a1 = cycle[pos][0];
        motor_a2 = cycle[pos][1];
        motor_b1 = cycle[pos][2];
        motor_b2 = cycle[pos][3];

        if (speed != 0) {
            if (speed > 0) {
                if (pos == 7)
                    pos = 0;
                else
                    pos++;
            }
            else {
                if (pos == 0)
                    pos = 7;
                else
                    pos--;
            }

            wait((60.0 * STEP_SIZE) / (360.0 * 8.0 * abs(speed)));
        } else {

        }
    }

    return 1;
}
