/*
 * Copyright (c) 2017, Aerialspecs, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include "Controller.h"

namespace com {
namespace aerialspecs {
namespace mbed {
namespace sketchlet {

Controller::Controller(uint8_t maxSketchlets) {
    this->sketchlets = new ArrayList<Sketchlet*>(maxSketchlets);
    this->iterator   = NULL;
    this->active     = NULL;
}

void Controller::append(Sketchlet* sketchlet) {
    this->sketchlets->append(sketchlet);
    sketchlet->setController(this);
}

void Controller::setup() {
    this->iterator = this->sketchlets->iterate();
    this->active   = this->sketchlets->get(0);
}

bool Controller::loop() {
    if(!this->active->loop())
        return this->nextSketchlet();
    else
        return true;
}

void Controller::gotoSketchlet(uint8_t at) {
    this->active->terminate();
    this->active = this->sketchlets->get(at);
    this->active->initialize();
}

bool Controller::nextSketchlet() {
    this->active->terminate();
    if(this->iterator->hasNext()) {
        this->active = this->iterator->next();
        this->active->initialize();
        return true;
    }
    else
        return false;
}

void Controller::reset() {
    this->iterator->reset();
    this->nextSketchlet();
}

Controller::~Controller() {
    delete this->sketchlets;
    delete this->iterator;
}

}}}}