/*
 * Copyright (c) 2017, Aerialspecs, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef SKETCHLET_H_
#define SKETCHLET_H_

#ifndef NULL
    #define NULL    0
#endif

#include "IController.h"

namespace com {
namespace aerialspecs {
namespace mbed {
namespace sketchlet {

class Sketchlet {
public:
    Sketchlet();

    virtual void setController(IController* controller);

    virtual IController* getController();

    virtual void initialize() = 0;

    virtual bool loop() = 0;

    virtual void terminate() = 0;

    virtual ~Sketchlet();

protected:
    IController* controller;
};

}}}}

#endif /* SKETCHLET_H_ */