/*
 * Copyright (c) 2017, Aerialspecs, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef CONTROLLER_H_
#define CONTROLLER_H_

#include <stdint.h>

#include "ArrayList.hpp"
#include "Iterator.hpp"
#include "IController.h"
#include "Sketchlet.h"

namespace com {
namespace aerialspecs {
namespace mbed {
namespace sketchlet {

class Controller : public IController {
public:
    Controller(uint8_t maxSketchlets);

    virtual void append(Sketchlet* sketchlet);

    virtual void gotoSketchlet(uint8_t at);

    virtual bool nextSketchlet();

    virtual void reset();

    virtual void setup();

    virtual bool loop();

    virtual ~Controller();

private:
    ArrayList<Sketchlet*>* sketchlets;
    Sketchlet*             active;
    Iterator<Sketchlet*>*  iterator;
};

}}}}

#endif /* CONTROLLER_H_ */