/*
 * Copyright (c) 2017, Aerialspecs, Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
 
#include "ArrayList.h"

namespace com {
namespace aerialspecs {
namespace mbed {
namespace sketchlet {

template <class T> ArrayList<T>::ArrayList(uint8_t usize) {
    this->usize     = usize;
    this->elements  = new T[this->usize];
    this->index     = 0;
}

template <class T> T ArrayList<T>::get(uint8_t at) {
    return this->elements[at];
}

template <class T> void ArrayList<T>::append(T element) {
    this->elements[this->index] = element;
    ++this->index;
}

template <class T> uint8_t ArrayList<T>::length() {
    return (this->index + 1);
}

template <class T> uint8_t ArrayList<T>::size() {
    return this->usize;
}

template <class T> Iterator<T>* ArrayList<T>::iterate() {
    return new Iterator<T>(this->elements, this->index);
}

template <class T> ArrayList<T>::~ArrayList() {
    delete[] this->elements;
}

}}}}