#include "mbed.h"
#include "rtos.h"

#define ON_SECS (10)
#define OFF_SECS (10)
#define SAMPLE_RATE_HZ (5)

Serial pc(USBTX, USBRX);
DigitalOut relay(p21);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
AnalogIn adc(p20);
LocalFileSystem local("local");

double get_voltage(double d) { /* calibrated in freezer */
    return 8.14*d;
}

void relay_thr(void const *argument) {
    int i;
    while(1) {
        relay = led1 = 1;
        for(i=0; i<ON_SECS; ++i) Thread::wait(1000);
        relay = led1 = 0;
        for(i=0; i<OFF_SECS; ++i) Thread::wait(1000);
    }
}

void log_thr(void const *argument) {
    FILE *fp = fopen("/local/bv.csv", "a");
    fprintf(fp,"BEGIN\n");
    fclose(fp);
    while(1) {
        led2 = 1;
        FILE *fp = fopen("/local/bv.csv", "a");
        fprintf(fp, "%d,%f\n",(int)relay,get_voltage(adc)-5.0);
        printf("%d,%f\n",(int)relay,get_voltage(adc)-5.0);
        fclose(fp);
        led2 = 0;
        Thread::wait(1000/SAMPLE_RATE_HZ);
    }
}

int main() {
    Thread relay_thread(relay_thr); // toggles relay
    Thread log_thread(log_thr); // logs batt voltage
    while(1);
}
