#include "mbed.h"
#include "main.h"
#include "sx1272-hal.h"
#include "debug.h"

#include "Grove_LCD_RGB_Backlight.h"

/* Set this flag to '1' to display debug messages on the console */
#define DEBUG_MESSAGE   1

/* Set this flag to '1' to use the LoRa modulation or to '0' to use FSK modulation */
#define USE_MODEM_LORA  1
#define USE_MODEM_FSK   !USE_MODEM_LORA

#define RF_FREQUENCY                                    864300000 // Hz
#define TX_OUTPUT_POWER                                 70        // 14 dBm

#if USE_MODEM_LORA == 1

    #define LORA_BANDWIDTH                              2         // [0: 125 kHz,
                                                                  //  1: 250 kHz,
                                                                  //  2: 500 kHz,
                                                                  //  3: Reserved]
    #define LORA_SPREADING_FACTOR                       7         // [SF7..SF12]
    #define LORA_CODINGRATE                             1         // [1: 4/5,
                                                                  //  2: 4/6,
                                                                  //  3: 4/7,
                                                                  //  4: 4/8]
    #define LORA_PREAMBLE_LENGTH                        8         // Same for Tx and Rx
    #define LORA_SYMBOL_TIMEOUT                         5         // Symbols
    #define LORA_FIX_LENGTH_PAYLOAD_ON                  false
    #define LORA_FHSS_ENABLED                           false  
    #define LORA_NB_SYMB_HOP                            4     
    #define LORA_IQ_INVERSION_ON                        false
    #define LORA_CRC_ENABLED                            true

#elif USE_MODEM_FSK == 1

    #define FSK_FDEV                                    25000     // Hz
    #define FSK_DATARATE                                19200     // bps
    #define FSK_BANDWIDTH                               50000     // Hz
    #define FSK_AFC_BANDWIDTH                           83333     // Hz
    #define FSK_PREAMBLE_LENGTH                         5         // Same for Tx and Rx
    #define FSK_FIX_LENGTH_PAYLOAD_ON                   false
    #define FSK_CRC_ENABLED                             true

#else
    #error "Please define a modem in the compiler options."
#endif

#define RX_TIMEOUT_VALUE                                35000      // in ms
#define BUFFER_SIZE                                     60      // Define the payload size here

#if( defined ( TARGET_KL25Z ) || defined ( TARGET_LPC11U6X ) )
DigitalOut led( LED2 );
#else
DigitalOut led( LED1 );
#endif

Serial pc(USBTX, USBRX); // tx, rx
AnalogIn   voltage(PC_5);
AnalogIn   current(A1);
Ticker measure;
Ticker send;
Grove_LCD_RGB_Backlight lcd(I2C_SDA, I2C_SCL);

//Grove_LCD_RGB_Backlight rgbLCD(I2C_SDA, I2C_SCL);

/*
 *  Global variables declarations
 */
typedef enum
{
    LOWPOWER = 0,
    IDLE,

    RX,
    RX_TIMEOUT,
    RX_ERROR,

    TX,
    TX_TIMEOUT,

    CAD,
    CAD_DONE
}AppStates_t;

volatile AppStates_t State = LOWPOWER;

/*!
 * Radio events function pointer
 */
static RadioEvents_t RadioEvents;

/*
 *  Global variables declarations
 */
SX1272MB2xAS Radio( NULL );

//const uint8_t Msg[];

uint16_t BufferSize = BUFFER_SIZE;
uint8_t Buffer[BUFFER_SIZE];

int16_t RssiValue = 0.0;
int8_t SnrValue = 0.0;
//float measured_sinus = 0.0;
int16_t j = 0;
float voltage_sinus, current_sinus;
volatile float Vsum = 0,Vmax =0, Vmean = 0, Imax =0, Isum = 0, Imean = 0, Ud = 0,  Id = 0, cosi = 0;
volatile double P = 0, P2 = 0, S2 = 0, P1=0, S1=0;


uint16_t strSize = 0;
char str[BUFFER_SIZE];
char monitor[16]="0", monitor1[16]="0";



void meas (void)
{
        
        j++;
        
        voltage_sinus = voltage*2200;
        current_sinus = current*5;
        Vsum+=voltage_sinus;
        Isum+=current_sinus;
        if (voltage_sinus>Vmax)
                Vmax=voltage_sinus;
        if (current_sinus>Imax)
                Imax=current_sinus;
        
        P=P+(((voltage_sinus-Vmean)*(current_sinus-Imean))*(0.0002/3600000));
        P2=P2+((voltage_sinus-Vmean)*(current_sinus-Imean));
        if((((voltage_sinus-Vmean)*(current_sinus-Imean))*(0.0002/3600000))>0)
        S2=S2+((voltage_sinus-Vmean)*(current_sinus-Imean));
        
        
        if (j>=300)
        {
            j = 0;
            Vmean=Vsum/(300);
            Imean = Isum/(300);
            P1=P2/300; S1=S2/300;
            Ud=(Vmax-Vmean)/1.41;
            Id=(Imax-Imean)/1.41;
            Vmax = 0; Imax = 0; Vsum=0; Isum =0;

            cosi = P2/S2;
            P2=0; S2=0;
        }
}

void transmit (void)
{
            strSize = sprintf ( str, "0001, %10.4f, %5.4f, %5.4f, %5.4f", P, cosi, P1*1.41, S1*1.41);
            State=TX;
}





int main( void ) 
{


    
    
    
    
    //uint8_t i;
    //bool isMaster = true;

    debug( "\n\n\r     SX1272 Ping Pong Demo Application \n\n\r" );

    // Initialize Radio driver
    RadioEvents.TxDone = OnTxDone;
    RadioEvents.RxDone = OnRxDone;
    RadioEvents.RxError = OnRxError;
    RadioEvents.TxTimeout = OnTxTimeout;
    RadioEvents.RxTimeout = OnRxTimeout;
    Radio.Init( &RadioEvents );

    // verify the connection with the board
    while( Radio.Read( REG_VERSION ) == 0x00  )
    {
        debug( "Radio could not be detected!\n\r", NULL );
        wait( 1 );
    }

    debug_if( ( DEBUG_MESSAGE & ( Radio.DetectBoardType( ) == SX1272MB2XAS ) ), "\n\r > Board Type: SX1272MB2xAS < \n\r" );

    Radio.SetChannel( RF_FREQUENCY ); 

#if USE_MODEM_LORA == 1

    debug_if( LORA_FHSS_ENABLED, "\n\n\r             > LORA FHSS Mode < \n\n\r" );
    debug_if( !LORA_FHSS_ENABLED, "\n\n\r             > LORA Mode < \n\n\r" );

    Radio.SetTxConfig( MODEM_LORA, TX_OUTPUT_POWER, 0, LORA_BANDWIDTH,
                         LORA_SPREADING_FACTOR, LORA_CODINGRATE,
                         LORA_PREAMBLE_LENGTH, LORA_FIX_LENGTH_PAYLOAD_ON,
                         LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP,
                         LORA_IQ_INVERSION_ON, 2000 );

    Radio.SetRxConfig( MODEM_LORA, LORA_BANDWIDTH, LORA_SPREADING_FACTOR,
                         LORA_CODINGRATE, 0, LORA_PREAMBLE_LENGTH,
                         LORA_SYMBOL_TIMEOUT, LORA_FIX_LENGTH_PAYLOAD_ON, 0,
                         LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP,
                         LORA_IQ_INVERSION_ON, true );

#elif USE_MODEM_FSK == 1

    debug("\n\n\r              > FSK Mode < \n\n\r" );
    Radio.SetTxConfig( MODEM_FSK, TX_OUTPUT_POWER, FSK_FDEV, 0,
                         FSK_DATARATE, 0,
                         FSK_PREAMBLE_LENGTH, FSK_FIX_LENGTH_PAYLOAD_ON,
                         FSK_CRC_ENABLED, 0, 0, 0, 2000 );

    Radio.SetRxConfig( MODEM_FSK, FSK_BANDWIDTH, FSK_DATARATE,
                         0, FSK_AFC_BANDWIDTH, FSK_PREAMBLE_LENGTH,
                         0, FSK_FIX_LENGTH_PAYLOAD_ON, 0, FSK_CRC_ENABLED,
                         0, 0, false, true );

#else

#error "Please define a modem in the compiler options."

#endif

    //debug_if( DEBUG_MESSAGE, "Starting Ping-Pong loop\r\n" );

    led = 0;

    //Radio.Rx( RX_TIMEOUT_VALUE );

        
        //int n = 0;
        
        
        
    
        measure.attach_us(&meas, 200);
        send.attach(&transmit, 10);
        
    while( 1 )
    {
        
        
        
        lcd.setRGB(0, 255, 0);

 
        
        sprintf(monitor, "U=%3.0fV, I=%3.2fA", Ud, Id);
        sprintf(monitor1, "P=%8.2f kWh", P);
        // Print a message to the LCD.
        lcd.locate(0, 0);
        lcd.print(monitor);
        lcd.locate(0, 1);
        lcd.print(monitor1);
        
        switch( State )
        {
        case RX:
            //Radio.Rx( RX_TIMEOUT_VALUE );
            State = LOWPOWER;
            break;
        case TX:
            strcpy(( char* )Buffer, ( char* ) str);
            Radio.Send((uint8_t *) Buffer, BufferSize );
                //Radio.Rx( RX_TIMEOUT_VALUE );
            State = LOWPOWER;
            break;
        case RX_TIMEOUT:
            //Radio.Rx( RX_TIMEOUT_VALUE );
            State = LOWPOWER;
            break;
        case RX_ERROR:
            State = LOWPOWER;
            break;
        case TX_TIMEOUT:
            //Radio.Rx( RX_TIMEOUT_VALUE );
            State = LOWPOWER;
            break;
        case LOWPOWER:
            break;
        default:
            State = LOWPOWER;
            break;
        }

        wait(5);
    }
}

void OnTxDone( void )
{
    Radio.Sleep( );
    State = TX;
    debug_if( DEBUG_MESSAGE, "\r\n> OnTxDone\n\r" );
}

void OnRxDone( uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr )
{
    Radio.Sleep( );
    BufferSize = size;
    memcpy( Buffer, payload, BufferSize );
    RssiValue = rssi;
    SnrValue = snr;
    
    State = RX;
    debug_if( DEBUG_MESSAGE, "\r\n> OnRxDone\n\r" );
}

void OnTxTimeout( void )
{
    Radio.Sleep( );
    State = TX_TIMEOUT;
    debug_if( DEBUG_MESSAGE, "\r\n> OnTxTimeout\n\r" );
}

void OnRxTimeout( void )
{
    Radio.Sleep( );
    Buffer[BufferSize] = 0;
    State = RX_TIMEOUT;
    debug_if( DEBUG_MESSAGE, "\r\n> OnRxTimeout\n\r" );
}

void OnRxError( void )
{
    Radio.Sleep( );
    State = RX_ERROR;
    debug_if( DEBUG_MESSAGE, "\r\n> OnRxError\n\r" );
}
