    //////////////////////////////////////////
  //                                          //
//    Guitar Tuner via Goertzel's Algorithm     //
//          Created by: Andrew Durand           //
  //                                          //
    //////////////////////////////////////////

#include "mbed.h"
#include "adc.h"
#include "NokiaLCD.h"
#include <math.h>
#define PI 3.1415
#define SAMPLE_RATE 24000

DigitalOut led_low(LED1);
DigitalOut led_ok(LED2);
DigitalOut led_high(LED4);
InterruptIn button1(p12);

//LCD and Other Random Variables
NokiaLCD lcd(p5, p7, p8, p9, NokiaLCD::LCD6610); // mosi, sclk, cs, rst, type
int string_select = 0;
float high, high1, in_tune, in_tune1, in_tune2, in_tune3,
low, low1, note, low_mod, high_mod;
char* key;
int Counter = 0;
int Buffer[6000];

float goertzelFilter(int samples[], float freq, int N) {
    float s_prev = 0.0;
    float s_prev2 = 0.0;
    float coeff,normalizedfreq,power,s,k;
    int i;
    normalizedfreq = freq / SAMPLE_RATE;
    coeff = 2*cos(2*PI*normalizedfreq);
    for (i=0; i<N; i++) {
        s = samples[i] + coeff * s_prev - s_prev2;
        s_prev2 = s_prev;
        s_prev = s;
    }
    power = s_prev2*s_prev2+s_prev*s_prev-coeff*s_prev*s_prev2;
    return power;
}

ADC adc(SAMPLE_RATE, 1);

void sample_audio(int chan, uint32_t value) {
    Buffer[Counter] = adc.read(p20);
    Counter += 1;
}

void button1_pressed() {
    string_select++;
    if (string_select > 5) string_select = 0;
}

int main() {
    //Interupt for Switching Strings
    button1.mode(PullDown);
    button1.rise(&button1_pressed);

    //Setup LCD
    lcd.background(0xF0000F);
    lcd.cls();

    while (1) {

        switch (string_select) {
            case 0:
                note = 82;
                key= "E2";
                break;
            case 1:
                note = 110;
                key= "A2";
                break;
            case 2:
                note = 147;
                key= "D3";
                break;
            case 3:
                note = 196;
                key= "G3";
                break;
            case 4:
                note = 247;
                key= "B3";
                break;
            case 5:
                note = 330;
                key= "E4";
                break;
        }

        //Prepare for burst mode on all ADC pins and set up interrupt handler (using ADC library from Simon Blandford
        adc.append(sample_audio);
        adc.startmode(0,0);
        adc.burst(1);
        adc.setup(p20,1);

        //start the interrupt and wait for about 4096 samples
        adc.interrupt_state(p20,1);
        wait(.2);

        //Finsh up - Unset pin 20
        adc.interrupt_state(p20,0);
        adc.setup(p20,0);
        int actual_rate = adc.actual_sample_rate();

        //for debugging tell the terminal sample rate and how many samples we took
        printf("Requested max sample rate is %u, actual max sample rate is %u.\n",
               SAMPLE_RATE, actual_rate);
        printf("We did %i samples\n",Counter);

high = 0;
low = 0;
for (int i=3; i<46; i+=3) {
    high1 = goertzelFilter(Buffer, (note + i ), Counter);
    if (high1 > high) high=high1;
}
for (int i=3; i<46; i+=3) {
    low1 = goertzelFilter(Buffer, (note - i ), Counter);
    if (low1 > low) low=low1;
}
        in_tune1 =  goertzelFilter(Buffer, (note+1), Counter);
        in_tune2 =  goertzelFilter(Buffer, note, Counter);
        in_tune3 =  goertzelFilter(Buffer, (note-1), Counter);
        
        if ((in_tune1 > in_tune2) && (in_tune1 > in_tune3)) in_tune = in_tune1;
        else if ((in_tune2 > in_tune1) && (in_tune2 > in_tune3)) in_tune = in_tune2;
        else in_tune = in_tune3;
       // printf("high = %.2f, low = %.2f, in_tune = %.2f", high, low, in_tune);
//       high_mod = high/in_tune;
  //     low_mod = low/in_tune; 
    //    if ((high_mod > .8)&&(low_mod > .8)) {
      //      led_high = 0;
        //    led_ok = 0;
         //   led_low = 0; 
       // }
        if ((in_tune > high) && (in_tune > low)) {
            led_high = 0;
            led_ok = 1;
            led_low = 0;
        } else if (high > in_tune) {
            led_high = 1;
            led_ok = 0;
            led_low = 0;
        } else if (low > in_tune) {
            led_high = 0;
            led_ok = 0;
            led_low = 1;
        } else {
            led_high = 0;
            led_ok = 0;
            led_low = 0;
        }
        
        // Display on the LCD
        lcd.locate(0,1);
        lcd.printf("::Guitar Tuner::");
        lcd.locate(0,3);
        lcd.printf("Tuning String: %i", (6-string_select));
        lcd.locate(0,5);
        lcd.printf("%s at %i Hz",key, (int) note);
        lcd.locate(5,7);
        if (led_ok) lcd.printf("In Tune!");
        else if (led_low) lcd.printf("Too Low ");
        else if (led_high) lcd.printf("Too High");
        else lcd.printf("~~~~~~~~");

        Counter = 0;

    }



}