

#include "mbed.h"

#define LOOPTIME        100

Serial right(PC_10,PC_11);
Serial left(PC_12,PD_2);
Serial pc(USBTX,USBRX);
char BUFF_L[3];
char BUFF_R[3];
uint8_t idx_L = 0;
uint8_t idx_R = 0;
uint8_t stf_L = 0;
uint8_t stf_R = 0;
int16_t left_actual_receive = 0;
int16_t left_target_send = 0;
float omega_left_actual;
float omega_left_target;
int16_t right_actual_receive = 0;
int16_t right_target_send = 0;
float omega_right_actual;
float omega_right_target;
char temp_msg[8];

CAN         can1(PB_8, PB_9, 1000000);              //1Mbps, contain critical torque command message
CANMessage  can_msg_Rx;
CANMessage  can_msg_Tx;

void readFeadback_angularVel_L()
{
    uint8_t temp;
    temp = left.getc();
    if(stf_L) {
        BUFF_L[idx_L] = temp;
        idx_L = idx_L+1;
        if(idx_L == 3) {
            stf_L = 0;
            idx_L = 0;
            if(BUFF_L[2] == '}') {
                left_actual_receive = BUFF_L[0]<<8 | BUFF_L[1];
                omega_left_actual = left_actual_receive * 0.00031434064f;
            }
        }
    } else if(temp=='{') {
        stf_L = 1;
    }
}

void readFeadback_angularVel_R()
{
    uint8_t temp;
    temp = right.getc();
    if(stf_R) {
        BUFF_R[idx_R] = temp;
        idx_R = idx_R+1;
        if(idx_R == 3) {
            stf_R = 0;
            idx_R = 0;
            if(BUFF_R[2] == '}') {
                right_actual_receive = BUFF_R[0]<<8 | BUFF_R[1];
                omega_right_actual = right_actual_receive * 0.00031434064f;
            }
        }
    } else if(temp=='{') {
        stf_R = 1;
    }
}


void sendCmd_wheel_angularVel_L()
{
    left_target_send = omega_left_target/0.00031434064f;
    char sT_L = '{';
    uint8_t sH_L = left_target_send>>8U;
    uint8_t sL_L = left_target_send;
    char sP_L = '}';
    left.putc(sT_L);
    left.putc(sH_L);
    left.putc(sL_L);
    left.putc(sP_L);
}

void sendCmd_wheel_angularVel_R()
{
    right_target_send = omega_right_target/0.00031434064f; //convert rad/s to 16 bit integer to send
    char sT_R = '{'; //send start byte
    uint8_t sH_R = right_target_send >> 8U; //send high byte
    uint8_t sL_R = right_target_send;  //send low byte
    char sP_R = '}'; //send stop byte
    right.putc(sT_R);
    right.putc(sH_R);
    right.putc(sL_R);
    right.putc(sP_R);
}

void Rx_CAN1(void)
{
    int16_t tmp;

    if(can1.read(can_msg_Rx)) {
        switch(can_msg_Rx.id) {                                 //Filtered input message
            // Start of 100Hz msg
            case 0xA0://1
                //HSB from FL motor drive
                tmp = can_msg_Rx.data[5] << 8 | can_msg_Rx.data[4];
                omega_left_target = tmp*1.0f;
                tmp = can_msg_Rx.data[3] << 8 | can_msg_Rx.data[2];
                omega_right_target = tmp * 0.01f;
                break;
        }
    }
}

void CANpendTX(void)
{
    //Pend till TX box has empty slot, timeout will generate error
    uint32_t timeout = 0;
    while(!(CAN1->TSR & CAN_TSR_TME_Msk)) {
        //Wait till non empty
        timeout += 1;
        if(timeout > 10000) {
            // Put some timeout error handler
            break;
        }
    }
}

void Tx_Tcmd_CAN1(void)    
{
    int16_t tmp;
//    tmp = (int16_t) (FL_Tcmd * 100.0f);
//    temp_msg[0] = tmp;
//    temp_msg[1] = tmp >> 8U;
//    temp_msg[2] = RTD_cmd;
//    temp_msg[3] = RST_cmd;
//    temp_msg[4] = 0U;
//    temp_msg[5] = 0U;
//    temp_msg[6] = 0U;
//    temp_msg[7] = 0U;
    can_msg_Tx = CANMessage(0xC0,temp_msg,8,CANData,CANStandard);
    CANpendTX();
    can1.write(can_msg_Tx);
}

int main()
{
    pc.baud(115200);
    left.baud(57600);
    right.baud(57600);
    left.attach(&readFeadback_angularVel_L,Serial::RxIrq);
    right.attach(&readFeadback_angularVel_R,Serial::RxIrq);


    //Set CAN system
    SET_BIT(CAN1->MCR, CAN_MCR_ABOM);               // Enable auto reboot after bus off
    can1.filter(0xA0,0xFFFF,CANStandard,0);         // ID filter listing mode
//    can1.filter(0xA1,0xFFFF,CANStandard,1);
//    can1.mode(CAN::GlobalTest);                     // Add only for testing 2019/11/13
    can1.attach(&Rx_CAN1, CAN::RxIrq);              // CAN1 Recieve Irq

//    omega_left_target = 1.0f;
//    omega_right_target = 1.0f;

    while(1) {
//        printf("%d\n\r",int16_t(omega_left_actual*1000));
        printf("%d\n\r",right_actual_receive);

        sendCmd_wheel_angularVel_L();
        sendCmd_wheel_angularVel_R();
        Tx_Tcmd_CAN1();
        wait_ms(90);
    }
}
