#include "mbed.h"
#include "led.h"

DigitalOut pin_0(PG_2);
DigitalOut pin_1(PG_3);
DigitalOut pin_2(PG_4);
DigitalOut pin_3(PG_5);

enum StepDirection {Left, Right};

void Led_Init(){
    pin_0=1;
    pin_1=0;
    pin_2=0;
    pin_3=0;
    
}

void Led_On(unsigned char ucLedIndeks){
    pin_0=0;
    pin_1=0;
    pin_2=0;
    pin_3=0;
    switch(ucLedIndeks){
        case 0:
            pin_0=1;
            break;
        case 1:
            pin_1=1;
            break;
        case 2:
            pin_2=1;
            break;
        case 3:
            pin_3=1;
            break;
        default:
            break;
    }
}


void Led_Step(enum StepDirection Direction){
    static unsigned int uiPozycjaPunktu;
    switch(Direction){
        case Left:
            uiPozycjaPunktu = (++uiPozycjaPunktu) % 4;
            break;
        case Right:
            uiPozycjaPunktu = (--uiPozycjaPunktu) % 4;
            break;
        default:
            break;
    }
    Led_On(uiPozycjaPunktu);
}

void Led_StepLeft(){
    Led_Step(Left);
}

void Led_StepRight(){
    Led_Step(Right);
}
