#include "servo.h"
#include "led.h"
#include "mbed.h"

Ticker timer;
DigitalIn detector(PG_6);

enum eStan {ACTIVE, INACTIVE};

enum eStan eReadDetector(){
    if(1==detector){
        return INACTIVE;
    }
    else{
        return ACTIVE;
    }
}

enum ServoState {CALLIB, IDDLE, IN_PROGRESS};

struct Servo
{ 
 enum ServoState eState; 
 unsigned int uiCurrentPosition; 
 unsigned int uiDesiredPosition;
};

struct Servo sServo;

void Automat(){
    switch(sServo.eState){
            case CALLIB:
                if(eReadDetector()==INACTIVE){
                    Led_StepLeft();
                    sServo.eState=CALLIB;
                }
                else{
                    sServo.uiCurrentPosition=0;
                    sServo.uiDesiredPosition=0;
                    sServo.eState=IDDLE;
                }
                break;
            case IDDLE:
                if(sServo.uiCurrentPosition != sServo.uiDesiredPosition){
                    sServo.eState=IN_PROGRESS;
                }
                else{
                    sServo.eState=IDDLE;
                }
                break;
            case IN_PROGRESS:
                if(sServo.uiCurrentPosition == sServo.uiDesiredPosition){
                    sServo.eState=IDDLE;
                } 
                else if(sServo.uiCurrentPosition < sServo.uiDesiredPosition){
                    Led_StepRight();
                    sServo.uiCurrentPosition++;
                    sServo.eState=IN_PROGRESS;
                }
                else {
                    Led_StepLeft();
                    sServo.uiCurrentPosition--;
                    sServo.eState=IN_PROGRESS;
                }
                break;
        }   
}

void Servo_Init(unsigned int uiServoFrequency){
    float fServoFrequency; 
    const float ucConstOne=1;
    fServoFrequency= ucConstOne / uiServoFrequency;
    Led_Init();
    sServo.eState=CALLIB;
    timer.attach(&Automat,fServoFrequency);
}

void Servo_Callib(void){
    sServo.eState=CALLIB;
}

void Servo_GoTo(unsigned int uiPosition){
    sServo.uiDesiredPosition=uiPosition;
}

void Servo_Step(unsigned int uiStep){
    sServo.uiDesiredPosition=sServo.uiCurrentPosition+uiStep;
}
